<?php
/**
 * Captioned Image with Markers Section
 *
 * Flexible content section for 'captioned_image_with_markers' section.
 *
 * @package Fishers_Theme
 */

$direction = get_sub_field('direction');
$content = get_sub_field('content');
$image = get_sub_field('image');

?>

<section class="s-captionedImage s-captionedImage--withMarkers s-captionedImage--<?= $direction; ?>" data-full>
    <div class="contain">
        <div class="s-captionedImage__row row">
            <div class="col-12 col-lg-6">
                <div class="s-captionedImage__content flex-column pt-4 pb-5 flow">
                    <?= $content; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="s-captionedImage__markWrap">
        <?= Blue2\Scruffy\Utils::acf_img($image, [
            'class' => 's-captionedImage__img'
        ]);
        ?>
        <a class="s-captionedImage__mark markInverness" target="_blank" href="
        https://www.google.co.uk/maps/place/63+Carsegate+Rd,+Inverness+IV3+8EX/@57.4961391,-4.3134873,12z/data=!4m5!3m4!1s0x488f74041c1d9855:0xe30293932ec6b348!8m2!3d57.4882745!4d-4.2497687">
            <img src="<?= get_template_directory_uri(); ?>/dist/images/1489157558invernesss2x.png">
        </a>
        <a class="s-captionedImage__mark markGlasgow" target="_blank" href="
        https://www.google.co.uk/maps/place/18+Palacecraig+St,+Coatbridge+ML5/@55.8453431,-4.0246292,15.83z/data=!4m5!3m4!1s0x48886bb8237395bb:0xadc9810d3285b4ed!8m2!3d55.8461005!4d-4.0263755">
            <img src="<?= get_template_directory_uri(); ?>/dist/images/1489158231glasgow2x.png">
        </a>
        <a class="s-captionedImage__mark markFalkirk" target="_blank" href="
        https://www.google.co.uk/maps/place/Prestonhall+Industrial+Estate,+Cupar+KY15+4RD/@56.325011,-2.9884048,17z/data=!3m1!4b1!4m5!3m4!1s0x4886501fe3a99977:0x7aa701c4fca1af3b!8m2!3d56.325011!4d-2.9862161">
            <img src="<?= get_template_directory_uri(); ?>/dist/images/1489158107falkirk2x.png">
        </a>
        <a class="s-captionedImage__mark markEdinburgh" target="_blank" href="
        https://www.google.co.uk/maps/place/Fisher+Services/@55.8324898,-3.4450495,10.96z/data=!4m5!3m4!1s0x0:0x8beef966fed694c4!8m2!3d55.8772612!4d-3.5386768">
            <img src="<?= get_template_directory_uri(); ?>/dist/images/1489157781edinburgh2x.png">
        </a>
        <a class="s-captionedImage__mark markNewcastle" target="_blank" href="
        https://www.google.co.uk/maps/place/Fishers+Services+Ltd/@55.0085943,-1.4897238,17z/data=!4m8!1m2!2m1!1sIntersect+19+High+Flatworth+Tyne+Tunnel+Industrial+Estate+North+Shields+NE29+7UT!3m4!1s0x487e6e383b5ae0db:0x95f048d18a16a1a0!8m2!3d55.0080976!4d-1.4867877">
            <img src="<?= get_template_directory_uri(); ?>/dist/images/1489157832newcastle2x.png">
        </a>
       
    </div>
</section>
