<?php
/**
 * Site Footer
 *
 * Includes footer navigation, colophon
 *
 * @package Fisher_Theme
 */

?>

<footer class="l-footer text-primary">
    <div class="l-footer__mob contain bg-primary d-md-none text-white">

        <?php if (has_nav_menu('categories')) { ?>
            <h3 id="footer-category-title" class="l-footer__catTitle ff-alt fw-medium text-white">Explore our news categories:</h3>
            <nav aria-labelledby="footer-category-title" class="b-categories mb-5">
                <?php wp_nav_menu([
                    'theme_location'    => 'categories',
                    'menu_container'    => 'ul',
                    'menu_class'        => 'b-categories__list text-center',
                    'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                ]); ?>
            </nav>
        <?php } ?>

        <?php if (has_nav_menu('services')) { ?>
            <h2 class="fs-7 text-white ff-alt fw-medium">Dependable service</h2>
            <?php wp_nav_menu([
                'theme_location'    => 'services',
                'menu_container'    => 'ul',
                'menu_class'        => 'b-serviceButtons',
                'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
            ]); ?>
        <?php } ?>
    </div>

    <?php get_template_part('templates/parts/illustration', null, ['class' => 'footer']); ?>

    <div class="contain mt-4">
        <div class="l-footer__top d-flex flex-wrap align-items-center justify-content-between">
            <div class="l-footer__brand">
                <img src="<?= get_template_directory_uri(); ?>/dist/images/fishers-logo.svg" width="213.1" height="65.8">

                <?php
                $social_media = get_field('social_media_channels', 'options');
                if ($social_media) {
                    $networks = [
                        'linkedin'  => [
                            'label' => 'LinkedIn',
                            'icon'  => 'fab fa-linkedin-in'
                        ],
                        'twitter'   => [
                            'label' => 'Twitter',
                            'icon'  => 'fab fa-twitter'
                        ]
                    ];
                    foreach ($social_media as $channel) { ?>
                        <a class="l-footer__social d-md-none" href="<?= $channel['full_url']; ?>">
                            <span class="<?= $networks[$channel['network']]['icon']; ?>" aria-hidden="true"></span>
                            <div class="visually-hidden"><?= $networks[$channel['network']]['label']; ?></div>
                        </a>
                    <?php }
                } ?>
            </div>
            <div class="l-footer__supports">
                <a href="https://www.chas.org.uk/" target="_blank"><img src="<?= get_template_directory_uri(); ?>/dist/images/chas.png"></a>
                <a href="https://scottishtourismalliance.co.uk/" target="_blank"><img src="<?= get_template_directory_uri(); ?>/dist/images/scottish-tourism.jpg"></a>
                <a href="https://www.scottishthistleawards.co.uk/"><img src="<?= get_template_directory_uri(); ?>/dist/images/thistle_award.png"></a>
            </div>
            <?php if (has_nav_menu('secondary')) { ?>
                <div class="l-footer__navWrap l-footer__navWrap--first">
                    <nav class="l-footer__nav">
                        <?php wp_nav_menu([
                            'theme_location'    => 'secondary',
                            'menu_container'    => 'ul',
                            'menu_class'        => 'l-footer__menu',
                            'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                        ]); ?>
                    </nav>
                </div>
                <?php } ?>
                
            
        </div>
        <div class="l-footer__bottom">
            <?php
            $social_media = get_field('social_media_channels', 'options');
            if ($social_media) {
                $networks = [
                    'linkedin'  => [
                        'label' => 'LinkedIn',
                        'icon'  => 'fab fa-linkedin-in'
                    ],
                    'twitter'   => [
                        'label' => 'Twitter',
                        'icon'  => 'fab fa-twitter'
                    ]
                ];
                foreach ($social_media as $channel) { ?>
                    <a class="l-footer__social d-none d-md-inline" href="<?= $channel['full_url']; ?>">
                        <span class="<?= $networks[$channel['network']]['icon']; ?>" aria-hidden="true"></span>
                        <div class="visually-hidden"><?= $networks[$channel['network']]['label']; ?></div>
                    </a>
                <?php }
            } ?>
            <div class="l-footer__copy fw-bold">&copy; <?= date('Y'); ?> Fishers Services.</div>
            <div class="l-footer__credit fw-medium">Website by <?= do_shortcode('[blue2_logo type="dark"]'); ?></div>
        </div>
    </div>
</footer>
