<?php
/**
 * Service - Images Section
 *
 * Flexible content section for 'service_iamges' section.
 *
 * @todo responsive images
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$content = get_sub_field('content');
$buttons = get_sub_field('buttons');
$images = get_sub_field('images');

?>

<section class="s-serviceImages">
    <div class="contain">
        <div class="row align-items-center">
            <div class="col-12 col-md-5">

                <div class="s-serviceImages__images">
                    <?php if ($images) {
                        foreach ($images as $i=>$image) { ?>
                            <div class="s-serviceImage__imageWrap" data-aos="fade-right" data-aos-delay="<?php echo ($i % 2 ) == 0 ? '200' : '0'; ?>">
                                <?= Blue2\Scruffy\Utils::acf_img($image, [
                                    'class'     => 's-serviceImage__image',
                                    'size'      => 'standard-image'
                                ]); ?>
                            </div>
                        <?php }
                    } ?>
                </div>

            </div>
            <div class="col-12 col-md-5 mx-auto flow">
                <h2><?= $title; ?></h2>

                <div class="measure-short flow">
                    <?= $content; ?>
                </div>

                <?php Blue2\Scruffy\Utils::Button_Row($buttons, [
                    'wrap_class' => 'flow-space-600'
                ]); ?>

            </div>
        </div>
    </div>
</section>
