<?php
/**
 * Features Section
 *
 * Flexible content section for 'features' section.
 *
 * @package Fishers_Theme
 */

$image_dir = get_template_directory_uri() . '/dist/images';

$id = is_front_page() ? ' id="first-content"' : null;

$features = get_sub_field('features');

?>

<section
    <?= $id; ?>
    class="s-features fs-5 text-primary"
    data-full>
    <h2 class="visually-hidden">Features</h2>
    <div class="s-features__contain contain">
        <div class="s-features__major">
            <div class="s-features__center text-center">
                <img class="s-features__country" src="<?= $image_dir; ?>/features-country.png" width="524" height="845" loading="lazy" alt="">
                <img class="s-features__logo" src="<?= $image_dir; ?>/fishers-logo.svg" width="213.1" height="65.8" alt="Fishers - A KBRO Company" loading="lazy">
                <img class="s-features__vans" src="<?= $image_dir; ?>/features-vans.png" width="530" height="186" loading="lazy" alt="Three Fishers lorries">
            </div>
            <?php if ($features) { ?>
                <div class="s-features__minorWrap">
                    <ul class="s-features__minor" role="list">
                        <?php foreach ($features as $feature) { ?>
                            <li class="s-features__item">
                                <?php if ($feature['bold']) { ?>
                                    <span class="fs-3 ff-alt fw-bold"><?= $feature['bold']; ?></span>
                                <?php } ?>
                                <?= $feature['text']; ?>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
            <?php } ?>
        </div>
    </div>
</section>
