<?php
/**
 * Site Header
 *
 * Includes header bar, navigation
 *
 * @package Fisher_Theme
 */

?>

<header class="l-header bg-primary text-white" data-state="closed">
    <div class="l-header__contain contain">
        <a class="l-header__brand" href="<?php echo esc_url(home_url('/')); ?>">
            <?php
            $path = get_template_directory() . '/dist/images/fishers-logo.svg';
            $file = file_get_contents($path);

            // remove xml header if present
            $file = str_replace(
                '<?xml version="1.0" encoding="UTF-8"?>',
                '',
                $file
            );

            // add class and attributes for accessibility
            echo str_replace(
                '<svg',
                '<svg class="l-header__logo" role="img" aria-label="Fishers - A KBRO Company"',
                $file
            );
            ?>
        </a>

        <nav class="l-header__nav l-nav">

            <button
                id="nav-toggle"
                type="button"
                class="l-header__btn l-header__btn--menu l-nav__toggle b-navToggle"
                data-state="closed"
                aria-controls="primary-nav"
                aria-expanded="false">
                <div class="b-navToggle__burger my-auto" aria-hidden="true">
                    <span class="b-navToggle__bar"></span>
                    <span class="b-navToggle__bar"></span>
                    <span class="b-navToggle__bar"></span>
                </div>
                Menu
            </button>

            <div class="l-nav__wrap text-center" id="primary-nav" data-state="closed">
                <?php if (has_nav_menu('primary')) {
                    wp_nav_menu([
                        'theme_location'    => 'primary',
                        'menu_container'    => 'ul',
                        'menu_class'        => 'l-nav__menu',
                        'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                    ]);
                } ?>
                <?php if (has_nav_menu('services')) {
                    wp_nav_menu([
                        'theme_location'    => 'services',
                        'menu_container'    => 'ul',
                        'menu_class'        => 'b-serviceButtons',
                        'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                    ]);
                } ?>
                <div class="text-white fs-3 d-md-none">
                    <a class="l-nav__social text-decoration-none" href="#0">
                        <span class="fab fa-twitter" aria-hidden="true"></span>
                        <span class="visually-hidden">Twitter</span>
                    </a>
                    <a class="l-nav__social text-decoration-none" href="#0">
                        <span class="fab fa-linkedin-in" aria-hidden="true"></span>
                        <span class="visually-hidden">LinkedIn</span>
                    </a>
                </div>
            </div>
        </nav>

        <div class="l-header__right">
            <a class="l-header__btn l-header__btn--login b-button" href="#0" data-style="inverse">
                <span class="fas fa-lock" aria-hidden="true"></span>
                <span class="d-none d-md-inline">Customer Login</span>
                <span class="d-display d-md-none">login</span>
            </a>

            <a class="l-header__kbro d-none d-md-inline" href="#0">
                <img src="<?= get_template_directory_uri(); ?>/dist/images/about-kbro.svg" width="151.8" height="17.9" alt="About KBRO" loading="eager">
            </a>
        </div>
    </div>

    <?php
    $phone = get_field('contact_phone_number', 'options');
    $email = get_field('contact_email_address', 'options');

    if ($phone || $email) { ?>
        <div class="l-header__contact text-white bg-primary-shade text-center ff-alt">
            <?php
            if ($phone) {
                printf(
                    '<a class="l-header__contactBtn" href="tel:%s">Tap here to call</a>',
                    esc_attr($phone)
                );
            }
            if ($email) {
                printf(
                    '<a class="l-header__contactBtn" href="mailto:%s">Tap here to call</a>',
                    sanitize_email($email)
                );
            }
            ?>
        </div>
    <?php } ?>
</header>
