import { fontawesome, throttle } from './utils';

import { hero, media, testimonials } from './sections/';

/**
 * nav
 *
 * mobile navigation toggle behaviour
 */
const nav = {
    breakpoint: 768,

    isOpen: false,
    lastWidth: window.innerWidth,

    el: {
        scrollEl:   document.documentElement,
        toggle:     document.querySelector('.l-nav__toggle'),
        nav:        document.querySelector('.l-nav__wrap'),
        header:     document.querySelector('.l-header'),
    },

    init: () => {
        nav.el.toggle.addEventListener('click', nav.toggle);
        window.addEventListener('resize', nav.resize);
    },

    toggle: () => {
        const isOpen = nav.el.toggle.getAttribute('data-state') === 'open';
        if (isOpen) {
            nav.close();
        } else {
            nav.open();
        }
    },

    open: () => {
        nav.el.scrollEl.style.overflow = 'hidden';

        nav.el.header.setAttribute('data-state', 'open');

        nav.el.nav.setAttribute('data-state', 'open');

        nav.el.toggle.setAttribute('data-state', 'open');
        nav.el.toggle.setAttribute('aria-expanded', 'true');

        nav.el.nav.focus();

        nav.isOpen = true;
    },

    close: () => {
        nav.el.scrollEl.style.overflow = null;

        nav.el.header.setAttribute('data-state', 'closed');

        nav.el.nav.setAttribute('data-state', 'closed');

        nav.el.toggle.setAttribute('data-state', 'closed');
        nav.el.toggle.setAttribute('aria-expanded', 'false');

        nav.el.toggle.focus();

        nav.isOpen = false;
    },

    resize: throttle(() => {
        const currentWidth = window.innerWidth;
        if (nav.isOpen && nav.lastWidth <= nav.breakpoint && currentWidth > nav.breakpoint) {
            nav.close();
        }
        nav.lastWidth = currentWidth;
    }, 1000)
};

const common = () => {
    nav.init();
    fontawesome();

    // sections
    hero();
    media();
    testimonials();
};

export default common;
