<?php
/**
 * Titlebar - Parent Section
 *
 * Flexible content section for 'titlebar_parent' section.
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$content = get_sub_field('content');
$links = get_sub_field('links');

?>

<section class="s-titlebarParent bg-primary text-white text-center" data-full>
    <div class="contain flow position-relative z-index-1">
        <h1 class="fs-0 text-white ff-alt fw-medium"><?= $title; ?></h1>

        <?php if ($content) { ?>
            <div class="s-titlebarParent__description measure-medium mx-auto">
                <?= $content; ?>
            </div>
        <?php } ?>

        <?php if ($links) { ?>
            <div class="s-titlebarParent__links row">
                <?php foreach ($links as $item) { ?>
                    <div class="col-12 col-md-6 col-xl-3">
                        <article class="s-titlebarParent__item position-relative">
                            <?= Blue2\Scruffy\Utils::acf_img($item['image'], [
                                'class'     => 's-titlebarParent__img'
                            ]); ?>
                            <h2 class="s-titlebarParent__title ff-alt fw-bold fs-3 text-white">
                                <a class="s-titlebarParent__link box-link text-decoration-none" href="<?= $item['link']['url']; ?>">
                                <?= $item['link']['title']; ?>
                                </a>
                            </h2>
                        </article>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>

    <?php get_template_part('templates/parts/illustration', null, [
        'class' => 's-titlebarParent__bg'
    ]); ?>
</section>
