<?php
/**
 * Site Footer
 *
 * Includes footer navigation, colophon
 *
 * @package Fisher_Theme
 */

?>

<footer class="l-footer text-primary">
    <div class="l-footer__mob contain bg-primary d-md-none text-white">

        <?php if (has_nav_menu('categories')) { ?>
            <h3 id="footer-category-title" class="l-footer__catTitle ff-alt fw-medium text-white">Explore our news categories:</h3>
            <nav aria-labelledby="footer-category-title" class="b-categories mb-5">
                <?php wp_nav_menu([
                    'theme_location'    => 'categories',
                    'menu_container'    => 'ul',
                    'menu_class'        => 'b-categories__list text-center',
                    'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                ]); ?>
            </nav>
        <?php } ?>

        <?php if (has_nav_menu('services')) { ?>
            <h2 class="fs-7 text-white ff-alt fw-medium">Dependable service</h2>
            <?php wp_nav_menu([
                'theme_location'    => 'services',
                'menu_container'    => 'ul',
                'menu_class'        => 'b-serviceButtons',
                'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
            ]); ?>
        <?php } ?>
    </div>

    <?php get_template_part('templates/parts/illustration'); ?>

    <div class="contain mt-4">
        <div class="l-footer__top d-flex flex-wrap align-items-center justify-content-between">
            <div class="l-footer__brand">
                <img src="<?= get_template_directory_uri(); ?>/dist/images/fishers-logo.svg" width="213.1" height="65.8">
                <a class="l-footer__social d-md-none" href="#0" aria-label="Twitter">
                    <span class="fab fa-twitter" aria-hidden="true"></span>
                </a>
                <a class="l-footer__social d-md-none" href="#0" aria-label="Linkedin">
                    <span class="fab fa-linkedin-in" aria-hidden="true"></span>
                </a>
            </div>

            <?php if (has_nav_menu('secondary')) { ?>
                <div class="l-footer__navWrap">
                    <nav class="l-footer__nav">
                        <?php wp_nav_menu([
                            'theme_location'    => 'secondary',
                            'menu_container'    => 'ul',
                            'menu_class'        => 'l-footer__menu',
                            'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                        ]); ?>
                    </nav>
                </div>
            <?php } ?>
        </div>
        <div class="l-footer__bottom">
            <a class="l-footer__social d-none d-md-inline" href="#0" aria-label="Twitter">
                <span class="fab fa-twitter" aria-hidden="true"></span>
            </a>
            <a class="l-footer__social d-none d-md-inline" href="#0" aria-label="Linkedin">
                <span class="fab fa-linkedin-in" aria-hidden="true"></span>
            </a>
            <div class="l-footer__copy fw-bold">&copy; <?= date('Y'); ?> Fishers Services.</div>
            <div class="l-footer__credit fw-medium">Website by <?= do_shortcode('[blue2_logo type="dark"]'); ?></div>
        </div>
    </div>
</footer>
