const changeSlide = (wrap, slide) => {
    // hide all slides
    const slider = wrap.querySelector('.s-testimonials__list');
    const slides = slider.querySelectorAll('.s-testimonials__single');
    slides.forEach(el => {
        el.setAttribute('data-visible', 'false');
    });

    // show active slide
    slides[slide].setAttribute('data-visible', 'true');
    slides[slide].focus();

    // update liveregion
    const live = wrap.querySelector('.s-testimonials__live');
    live.textContent = `Item ${parseInt(slide, 10) + 1} of ${slides.length}`;
};

const updateBtns = (wrap, btn) => {
    const allBtns = wrap.querySelectorAll('.s-testimonials__nav');

    allBtns.forEach(el => {
        el.setAttribute('data-active', 'false');
        el.querySelector('.s-testimonials__current').style.display = 'none';
    });

    btn.setAttribute('data-active', 'true');
    btn.querySelector('.s-testimonials__current').style.display = null;
};

const navClick = (wrap, btn) => {
    const slide = btn.getAttribute('data-slide');
    changeSlide(wrap, slide);
    updateBtns(wrap, btn);
};

export default () => {
    const testimonials = document.querySelectorAll('.s-testimonials');
    if (!testimonials) {
        return;
    }

    testimonials.forEach(wrap => {
        const navBtns = wrap.querySelectorAll('.s-testimonials__nav');

        if (navBtns) {
            navBtns.forEach(btn => {
                btn.addEventListener('click', () => navClick(wrap, btn));
            });
        }
    });
};
