<?php
/**
 * News Articles Section
 *
 * Flexible content section for 'news_articles' section.
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$category = get_sub_field('category');

$posts = get_posts([
    'numberposts' => 4
]);

if ($posts) { ?>
    <section class="s-newsArticles">
        <div class="contain contain-medium overflow-hidden">

            <div class="s-newsArticles__head ff-alt mb-5 text-primary-shade">
                <h2 class="s-newsArticles__title fw-medium text-inherit"><?= $title; ?></h2>

                <a class="fw-bold fs-7 text-decoration-none" href="<?php the_permalink(get_option('page_for_posts')); ?>">
                    View all news
                    <span class="far fa-angle-right" aria-hidden="true"></span>
                </a>
            </div>

            <div class="overflow-hidden">
                <div class="s-newsArticles__row row">
                    <?php foreach ($posts as $post) { ?>
                        <article class="s-newsArticles__item col-12 col-md-6 position-relative">
                            <div class="s-newsArticles__imageWrap">
                                <?php
                                $feat_image = get_field('feat_image', $post->ID);
                                if ($feat_image) {
                                    echo Blue2\Scruffy\Utils::acf_img($feat_image, [
                                        'class' => 's-newsArticles__image'
                                    ]);
                                } else {
                                    echo '<img class="s-newsArticles__image" src="' . get_template_directory_uri() . '/dist/images/news-placeholder.png" width="460" height="318" alt="" loading="lazy">';
                                } ?>
                            </div>
                            <div class="s-newsArticles__content flow">
                                <h3 class="s-newsArticles__itemTitle"><?= get_the_title($post->ID); ?></h3>

                                <p><?= Blue2\Scruffy\Utils::excerpt($post->ID, 15); ?></p>

                                <a class="ff-alt text-decoration-none text-primary fw-bold ms-auto box-link" href="#0">
                                    View article
                                    <span class="far fa-angle-right" aria-hidden="true"></span>
                                </a>
                            </div>
                        </article>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
<?php }
