<?php
/**
 * Post Archive Template
 *
 * @package Fishers_Theme
 */

$id = get_option('page_for_posts');
$custom_title = get_field('custom_title', $id);
$image = get_field('head_image', $id);
$feat_video = get_field('feat_video', $id);

$title = $custom_title ?: get_the_title($id);

?>

<main class="l-main">
    <section class="s-mediaHead bg-primary text-white" data-full>
        <div class="contain position-relative z-index-1">
            <h1 class="s-mediaHead__title text-center text-inherit ff-alt fw-medium"><?= $title; ?></h1>

            <h2 class="visually-hidden">Videos</h2>

            <div class="s-mediaHead__body">
                <div class="s-mediaHead__head mb-4">
                    <span class="fs-2 fw-bold" aria-hidden="true">Featured Video</span>
                    <a class="ff-alt fw-bold text-decoration-none" href="#0">
                        View All Videos
                        <span class="far fa-angle-right" aria-hidden="true"></span>
                    </a>
                </div>

                <article class="s-mediaHead__item s-mediaHead__item--featured">
                    <h3 class="visually-hidden">Featured Video</h3>
                    <?= $feat_video; ?>
                    <a class="s-mediaHead__view ff-alt fw-bold text-decoration-none" href="#0">
                        View Video
                        <span class="far fa-angle-right" aria-hidden="true"></span>
                    </a>
                </article>

                <?php for ($i = 0; $i < 3; $i++) { ?>
                    <article class="s-mediaHead__item s-mediaHead__item--normal">
                        <img class="me-3" src="<?= get_template_directory_uri(); ?>/dist/images/temp-video.jpg" alt="" width="197" height="111" loading="eager">
                        <h3 class="s-mediaHead__itemTitle text-inherit fs-6 fw-normal me-auto line-clamp">
                            Video title with space for a couple of lines
                        </h3>
                        <a class="s-mediaHead__view ff-alt fw-bold text-decoration-none align-self-end" href="#0">
                            View Video
                            <span class="far fa-angle-right" aria-hidden="true"></span>
                        </a>
                    </article>
                <?php } ?>
            </div>
        </div>
        <?= Blue2\Scruffy\Utils::acf_img($image, [
            'class'     => 's-mediaHead__bg multiply-bg',
            'loading'   => 'eager'
        ]); ?>
    </section>

    <section class="p-archive">
        <div class="contain contain-medium">
            <div class="p-archive__row row">

                <div class="p-archive__main col-12 col-md-8">
                    <h2 class="mb-4 ff-alt fw-bold">Articles</h2>

                    <div class="p-archive__list">
                        <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
                    </div>

                    <?php the_posts_pagination([
                        'class'     => 'p-archive__pagination',
                        'prev_text' => '
                            <span class="far fa-angle-left" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous page</span>
                        ',
                        'next_text' => '
                            <span class="far fa-angle-right" aria-hidden="true"></span>
                            <span class="visually-hidden">Next page</span>
                        '
                    ]); ?>
                </div>

                <div class="col-12 col-md-4">
                    <?php get_template_part('templates/post/sidebar'); ?>
                </div>
            </div>
        </div>
    </section>
</main>
