<?php
/**
 * Post Content Template
 *
 * @package Fishers_Theme
 */

$feat_image = get_field('feat_image');

?>

<article class="p-archive__item">
    <div class="p-archive__inner position-relative overflow-hidden">
        <div class="row">
            <div class="col-12 col-md-5">
                <?php if ($feat_image) {
                    echo Blue2\Scruffy\Utils::acf_img($feat_image, [
                        'class' => 'p-archive__image'
                    ]);
                } else {
                    echo '<img class="p-archive__image" src="' . get_template_directory_uri() . '/dist/images/news-placeholder.png" width="460" height="318" alt="" loading="lazy">';
                } ?>
            </div>
            <div class="col-12 col-md-7 flow flex-column">
                <h3>
                    <a href="<?php the_permalink(); ?>" class="box-link text-decoration-none">
                        <?php the_title(); ?>
                    </a>
                </h3>

                <p class="p-archive__desc <?= has_excerpt() ? 'p-archive__desc--excerpt' : 'p-archive__desc--content'; ?>">
                    <?= Blue2\Scruffy\Utils::excerpt(null, 25); ?>
                </p>

                <span class="p-archive__view mt-auto text-primary ff-alt fw-bold text-decoration-none ms-auto">
                    View article
                    <span class="far fa-angle-right" aria-hidden="true"></span>
                </span>
            </div>
        </div>
    </div>
</article>
