<?php
/**
 * News Articles Section
 *
 * Flexible content section for 'news_articles' section.
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$category = get_sub_field('category');

?>

<section class="s-newsArticles">
    <div class="contain contain-medium overflow-hidden">

        <div class="s-newsArticles__head ff-alt mb-5 text-primary-shade">
            <h2 class="s-newsArticles__title fw-medium text-inherit"><?= $title; ?></h2>

            <a class="fw-bold fs-7 text-decoration-none" href="#0">
                View all news
                <span class="far fa-angle-right" aria-hidden="true"></span>
            </a>
        </div>

        <div class="overflow-hidden">
            <div class="s-newsArticles__row row">
                <?php for ($i = 1; $i <= 4; $i++) { ?>
                    <article class="s-newsArticles__item col-12 col-md-6 position-relative">
                        <div class="s-newsArticles__imageWrap">
                            <img class="s-newsArticles__image" src="https://via.placeholder.com/393x222?text=<?= $i; ?>" width="393" height="222" alt="" loading="lazy">
                        </div>
                        <div class="s-newsArticles__content flow">
                            <h3 class="s-newsArticles__itemTitle">Article title to go here</h3>
                            <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque.</p>
                            <a class="ff-alt text-decoration-none text-primary fw-bold ms-auto box-link" href="#0">
                                View article
                                <span class="far fa-angle-right" aria-hidden="true"></span>
                            </a>
                        </div>
                    </article>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
