<?php
/**
 * Media Section
 *
 * Flexible content section for 'media' section.
 *
 * @todo pagination buttons in article scroller
 * @todo dynamic articles and new categories
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$link = get_sub_field('link');
$media = get_sub_field('media');

?>

<section class="s-media bg-primary text-white overflow-hidden" data-full>
    <div class="s-media__topContain contain">
        <div class="s-media__head">
            <h2 class="fs-1 ff-alt lh-1 text-white fw-medium"><?= $title; ?></h2>
            <?php if ($link) { ?>
                <a class="d-inline-block fs-7 mt-4" href="<?= $link['url']; ?>"><?= $link['title']; ?></a>
            <?php } ?>
        </div>

        <div class="s-media__articlesWrap">
            <ul class="s-media__articles" role="list">
                <?php for ($i = 0; $i < 6; $i++) { ?>
                    <li>
                        <article class="s-media__article">
                            <h3 class="s-media__articleTitle text-white fw-normal">
                                <a class="box-link" href="#0">
                                    News article title with space for a couple of lines
                                </a>
                            </h3>
                            <img class="s-media__articleThumb" src="https://via.placeholder.com/190x107?text=thumbnail" width="190" height="107" loading="lazy" alt="">
                            <span class="s-media__articleView ff-alt fw-bold" aria-hidden="true">
                                View Article
                                <span class="far fa-angle-right" aria-hidden="true"></span>
                            </span>
                        </article>
                    </li>
                <?php } ?>
            </ul>
            <button class="s-media__articleNav" data-dir="prev">
                <span class="far fa-angle-left" aria-hidden="true"></span>
                <span class="visually-hidden">Previous Item</span>
            </button>
            <button class="s-media__articleNav" data-dir="next">
                <span class="far fa-angle-right" aria-hidden="true"></span>
                <span class="visually-hidden">Nect Item</span>
            </button>
        </div>

    </div>

    <div class="contain">
        <?php if ($media) { ?>
            <div class="s-media__grid">
                <?php foreach ($media as $item) {
                    $layout = $item['acf_fc_layout'];
                    $layout = str_replace('_', '-', $layout);

                    unset($item['acf_fc_layout']);
                    $media_item_data = $item;

                    include __DIR__ . "/media/$layout.php";
                } ?>
            </div>
        <?php } ?>

    </div>
</section>
