<?php
/**
 * Checklist Section
 *
 * Flexible content section for 'checklist' section.
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$list = get_sub_field('list');
$images = get_sub_field('images');

?>

<section class="s-checklist">
    <div class="contain contain-medium">
        <div class="s-checklist__row">
            <div class="s-checklist__content">
                <h2 class="ff-alt fw-bold"><?= $title; ?></h2>

                <ul class="s-checklist__list fw-bold" role="list">
                    <?php foreach ($list as $item) { ?>
                        <li>
                            <span class="s-checklist__marker text-primary far fa-check" aria-hidden="true"></span>
                            <?= $item['text']; ?>
                        </li>
                    <?php } ?>
                </ul>
            </div>

            <div class="s-checklist__images">
                <?php foreach ($images as $image) { ?>
                    <div class="s-checklist__imageWrap">
                        <?= Blue2\Scruffy\Utils::acf_img($image, [
                            'class' => 's-checklist__image'
                        ]); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
