<?php
/**
 * Post Archive Template
 *
 * @package Fishers_Theme
 */

$id = get_option('page_for_posts');
$custom_title = get_field('custom_title', $id);
$image = get_field('head_image', $id);
$feat_video = get_field('feat_video', $id);

$title = $custom_title ?: get_the_title($id);

?>

<main class="l-main">
    <section class="s-mediaHead bg-primary text-white" data-full>
        <div class="contain position-relative z-index-1">
            <h1 class="s-mediaHead__title text-center text-inherit ff-alt fw-medium"><?= $title; ?></h1>

            <h2 class="visually-hidden">Videos</h2>

            <div class="s-mediaHead__body">
                <div class="s-mediaHead__head mb-4">
                    <span class="fs-2 fw-bold" aria-hidden="true">Featured Video</span>
                    <a class="ff-alt fw-bold text-decoration-none" href="#0">
                        View All Videos
                        <span class="far fa-angle-right" aria-hidden="true"></span>
                    </a>
                </div>

                <article class="s-mediaHead__item s-mediaHead__item--featured">
                    <h3 class="visually-hidden">Featured Video</h3>
                    <?= $feat_video; ?>
                    <a class="s-mediaHead__view ff-alt fw-bold text-decoration-none" href="#0">
                        View Video
                        <span class="far fa-angle-right" aria-hidden="true"></span>
                    </a>
                </article>

                <?php for ($i = 0; $i < 3; $i++) { ?>
                    <article class="s-mediaHead__item s-mediaHead__item--normal">
                        <img class="me-3" src="https://via.placeholder.com/197x111?text=thumb" alt="" width="197" height="111" loading="eager">
                        <h3 class="s-mediaHead__itemTitle text-inherit fs-6 fw-normal me-auto line-clamp">
                            Video title with space for a couple of lines
                        </h3>
                        <a class="s-mediaHead__view ff-alt fw-bold text-decoration-none align-self-end" href="#0">
                            View Video
                            <span class="far fa-angle-right" aria-hidden="true"></span>
                        </a>
                    </article>
                <?php } ?>
            </div>
        </div>
        <?= Blue2\Scruffy\Utils::acf_img($image, [
            'class'     => 's-mediaHead__bg multiply-bg',
            'loading'   => 'eager'
        ]); ?>
    </section>

    <section class="p-archive">
        <div class="contain contain-medium">
            <div class="p-archive__row row">

                <div class="p-archive__main col-12 col-md-8">
                    <h2 class="mb-4 ff-alt fw-bold">Articles</h2>

                    <div class="p-archive__list">
                        <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
                    </div>

                    <?php the_posts_pagination([
                        'class'     => 'p-archive__pagination',
                        'prev_text' => '
                            <span class="far fa-angle-left" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous page</span>
                        ',
                        'next_text' => '
                            <span class="far fa-angle-right" aria-hidden="true"></span>
                            <span class="visually-hidden">Next page</span>
                        '
                    ]); ?>
                </div>

                <aside class="col-12 col-md-4 flow">

                    <?php if (has_nav_menu('categories')) { ?>
                        <nav aria-labelledby="archive-cats-title" class="p-archive__cats bg-primary text-white">
                            <h2 id="archive-cats-title" class="text-inherit mb-4 ff-alt fw-medium">Explore our news categories:</h2>

                            <?php wp_nav_menu([
                                'theme_location'    => 'categories',
                                'menu_container'    => 'ul',
                                'menu_class'        => 'p-archive__catList fw-bold flow',
                                'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                            ]); ?>
                        </nav>
                    <?php } ?>

                    <?php if (has_nav_menu('services')) { ?>
                        <div class="p-archive__services text-primary-shade">
                            <h2 class="mb-4 ff-alt fw-medium fs-6 text-inherit">Dependable service</h2>

                            <?php wp_nav_menu([
                                'theme_location'    => 'services',
                                'menu_container'    => 'ul',
                                'menu_class'        => 'p-archive__servicesList ff-alt fw-bold flow',
                                'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                            ]); ?>
                        </div>
                    <?php } ?>

                    <div class="p-archive__feature b-feature b-feature--landscape text-white">
                        <div class="b-feature__inner flex-column">
                            <h3 class="b-feature__title text-inherit ff-alt">Dependable Partners.</h3>

                            <span class="b-feature__subtitle">
                                We offer a range of nationwide services in Hospitality, Workwear, Healthcare & Cleanroom.
                            </span>

                            <a class="b-feature__link ff-alt fw-bold box-link" href="<?= $link['url']; ?>">
                                Start your service with us today
                                <span class="b-feature__icon far fa-angle-right" aria-hidden="true"></span>
                            </a>
                        </div>

                        <img src="<?= get_template_directory_uri(); ?>/dist/images/illustration-feature.svg" alt="Illustration of Edinburgh Castle, bridge, and the Angel of the North" class="b-feature__image" width="1300" height="520" loading="lazy">
                    </div>
                </aside>
            </div>
        </div>
    </section>
</main>
