<?php

function ode_scripts() {
    wp_enqueue_style( 'custom', get_stylesheet_directory_uri().'/assets/custom.css' );
    wp_enqueue_script( 'jquery-ui-tabs');
}
add_action( 'wp_enqueue_scripts', 'ode_scripts' );

add_filter('pre_get_posts', 'my_get_posts');
function my_get_posts($query)
{
    global $wp_the_query;
    if (is_front_page() && $wp_the_query === $query) {
        $query->set('post_type', 'incsub_event');
    }
    return $query;
}
add_action('wp_head', 'move_events_buttons');

function move_events_buttons()
{
    ?>
    <script>

        function checkDateOfBirth(dob)
        {
            /*var MsYear = 31556952000;
            var diffMS = Math.abs(new Date() - jQuery('.hasDatepicker').datepicker('getDate'));
            var diffYear = diffMS/MsYear;*/

            var today = new Date();
            var age = today.getFullYear() - dob.getFullYear();
            var m = today.getMonth() - dob.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < dob.getDate())) {
                age--;
            }
            

            if (age < 6 || age > 14) {
                event.preventDefault();
                jQuery('#childErrors').html('<div class="acf-error-message"><p>Only children between the ages of 6 and 14 are eligible for registration.</p><a href="#" class="acf-icon -cancel small"></a></div>');
               
                return false;
            }
            else{
                jQuery('#childErrors').html('');
            }
            return true;

        }

        jQuery(document).ready(function () {
            
            jQuery( "#tabs" ).tabs();
            jQuery('.select2-chosen').html(<?php  if ($_SESSION && isset($_SESSION['countKids'])) { echo $_SESSION['countKids']; } ?>);
            jQuery(".wpmudevevents-buttons").appendTo("#wpmudevevents-contentbody");
            jQuery(".event-pagination").prependTo(".wpmudevevents-list");
            jQuery('.wpmudevevents-yes-submit').val('Register Interest');
            jQuery('#wpmudevevents-tickets>p>a').text('Proceed to payment');
            jQuery('#eab-success-notice').text('Thanks for registering interest in the event, please confirm booking using the proceed to payment/confirmation link');
            jQuery(".acf-button").text('Add Child');

            jQuery('.acf-form-submit .acf-button').click(function (event) {
                var numItems = $('.acf-row').length;
                console.log(numItems);
                if (numItems <=1 ) {
                    event.preventDefault();
                    jQuery('#childErrors').html('<div class="acf-error-message"><p>Please add at least one child.</p><a href="#" class="acf-icon -cancel small"></a></div>');
                }

                
                jQuery('.hasDatepicker').each(function () {
                    if(!$(this).hasClass('acf-clone')) {
                        if(!$(this).hasClass('kids-name')) {
                            var dob = jQuery(this).datepicker('getDate');
                            checkDateOfBirth(dob);
                        }
                    }
                });
            });

            jQuery('[data-name=kids_details]').on('change', '.hasDatepicker', function(){
                var dob = jQuery(this).datepicker('getDate');
                checkDateOfBirth(dob);
            });

            jQuery("<div class='clear'>").prependTo(".um-form");
            jQuery(".kid-edit-details").appendTo(".um-form");
            if(jQuery( "#datepicker" ).length) {
                jQuery( "#datepicker" ).datepicker({ dateFormat: 'dd-mm-yy' });
            };
        });
    </script>
    <?php
    if (is_user_logged_in()) { ?>
        <script>
            jQuery(document).ready(function () {
                jQuery('.wpmudevevents-yes-submit').click(function (event) {
                    if (jQuery('.checkbox input[type=checkbox]:checked').length < 1) {
                        event.preventDefault();
                        alert('Please select at least one child to attend');
                    }
                });
            });
        </script>
    <?php }
}

add_action('um_after_register_fields', 'add_acf_register_data');
add_action('um_after_account_general', 'add_acf_data');


function add_acf_register_data(){
    
        echo '<div id="childErrors"></div>';
    
        $user_id = get_current_user_id();
        $params = array(
            'field_groups' => array(411), // the ID of the field group
            'form' => true,
            'submit_value' => __("Register", 'acf')
        );
            
        acf_form($params);
}

function add_acf_data() {

    echo '<div id="childErrors"></div>';

    $user_id = get_current_user_id();
    $params = array(
        'field_groups' => array(411), // the ID of the field group
        'form' => true,
        'post_id' => 'user_'.$user_id,    );

    acf_form($params);
}


add_action('um_submit_account_details', 'updateChildData');
add_action('um_submit_account_errors_hook', 'updateChildData');
add_action('user_register', 'registerChildData');

function registerChildData($user_id)
{
    save_acf_data($user_id);
}
function updateChildData()
{
    save_acf_data(get_current_user_id());
}

function save_acf_data($user_id)
{
    // $post_id to save against
    $post_id = 'user_' . $user_id;
    // update the post
    do_action('acf/save_post', $post_id);
}

//add_action('um_account_tab__general', 'bookingDetails');
//add_action('wp_head', 'kidsDetails');
add_action('edit_user_profile', 'kidsDetailsCMS');

function kidsDetailsCMS() {

    global $user_id;
    $acfData = get_fields('user_' . $user_id);
    ?>
    <h2>Kids registered to this account</h2>
    <?php
    foreach($acfData['kids_details'] as $kidData){
        ?>
        <p><strong>Name: </strong><?php echo $kidData['kids_name']; ?><br><strong>Date Of Birth: </strong><?php echo $kidData['kids_dob'] ?>
        <br><strong>Address: </strong><?= $kidData['kids_address'] ?><br/>
        <?= $kidData['kids_address_2'] ?><br/>
        <?= $kidData['town'] ?><br/>
        <?= $kidData['postcode'] ?></p>
        <hr>
    <?php
    }
}


function kidsDetails() {
    if(is_page('account')) {
        $user_id = get_current_user_id();
        $userData = get_user_meta($user_id);
        $submittedData = $userData['submitted'];
        $data = $submittedData[0];
        $decodedData = unserialize($data);

        $kidsData = $decodedData['acf']['field_5804a636e4538'];
        if (isset($_POST['kidkey'])) {

            $alteredKidId = $_POST['kidkey'];

            if ($alteredKidId !== null) {

                $alteredKid = shortenArray($_POST);

                $kidsData[$alteredKidId] = $alteredKid;
                $decodedData['acf']['field_5804a636e4538'] = $kidsData;

                update_user_meta($user_id, 'submitted', $decodedData);
            }
        }
        ?>
        <div class="kid-edit-details">
            <div class="um-account-heading">Kids registered to this account NON CMS</div><br /><?php
            if ($kidsData) {
                $count = 0;
                foreach ($kidsData as $singleKidKey => $singleKid) {
                    $kidsName = $singleKid['field_5804a641e4539'];
                    $alteredKidddress = $singleKid['field_5804a647e453a'];
                    $kidAddress2 = $singleKid['field_58ca7a1c09a1b'];
                    $town = $singleKid['field_58ca7a3909a1c'];
                    $postcode = $singleKid['field_58ca7a4909a1d'];
                    $kidsDOB = $singleKid['field_5809cd60d0e2a'];


                    $dob = new Datetime($kidsDOB);
                    //echo $kidsDOB;
                    //echo $dob->format("d-m-Y");

                    $now = new Datetime('now');
                    $interval = $now->diff($dob);
                    $age = $interval->y;

                    ?>

                    <?php
                    if($kidsName != null && $age >= 6 && $age <= 14) {
                        ?>

                        <form id="<?php echo $singleKidKey; ?>" name="<?php echo $singleKidKey; ?>" action="" method="POST">
                            <input type="hidden" name="kidkey" value="<?php echo $singleKidKey; ?>">
                            <input type="text" placeholder="Kids name" name="field_5804a641e4539" class="kids-name" value="<?php echo $kidsName; ?>">
                            <input type="text" placeholder="Address 1" name="field_5804a647e453a" class="kids-name" value="<?php echo $alteredKidddress; ?>">
                            <input type="text" placeholder="Address 2" name="field_58ca7a1c09a1b" class="kids-name" value="<?php echo $kidAddress2; ?>">
                            <input type="text" placeholder="town" name="field_58ca7a3909a1c" class="kids-name" value="<?php echo $town; ?>">
                            <input type="text" placeholder="Postcode" name="field_58ca7a4909a1d" class="kids-name" value="<?php echo $postcode; ?>">
                            <input type="text" placeholder="Date of birth" name="field_5809cd60d0e2a" class="kids-name" id="datepicker" value="<?php echo $kidsDOB; ?>">
                            <input type="submit" value="save changes" class="submitForm">
                        </form>
                        <form name="delete_<?php echo $singleKidKey; ?>" action="" method="POST">
                            <input type="hidden" name="kidkey" value="<?php echo $singleKidKey; ?>">
                            <input type="hidden" placeholder="Kids name" name="field_5804a641e4539" class="kids-name" value="">
                            <input type="hidden" placeholder="Address 1" name="field_5804a647e453a" class="kids-name" value="">
                            <input type="hidden" placeholder="Address 2" name="field_5804a647e453a" class="kids-name" value="">
                            <input type="hidden" placeholder="town" name="field_5804a647e453a" class="kids-name" value="">
                            <input type="hidden" placeholder="Postcode" name="field_5804a647e453a" class="kids-name" value="">
                            <input type="hidden" placeholder="Date of birth" name="field_5809cd60d0e2a" class="kids-name" id="datepicker" value="">
                            <input type="submit" value="delete" class="deleteForm">
                        </form>
                        <br />

                        <?php
                    }
                    $count++;
                }
            }
            ?></div>

        <?php
    }
}

function getBookingDetails()
{
    global $wpdb;
    $user_id = get_current_user_id();
    $querystr = "  SELECT * FROM
(SELECT event_id, post_title,
MAX(CASE WHEN pm.meta_key = 'incsub_event_start' THEN pm.meta_value END)as 'start_time',
MAX(CASE WHEN pm.meta_key = 'incsub_event_end' THEN pm.meta_value END)as 'end_time',
MAX(CASE WHEN bm.meta_key = 'children_attending' THEN bm.meta_value END)as 'kids',
MAX(CASE WHEN bm.meta_key = 'booking_ticket_count' THEN bm.meta_value END) as 'tickets'
FROM pex_doe_events_eab_bookings AS b 
JOIN pex_doe_events_posts AS p ON b.event_id = p.ID
JOIN pex_doe_events_postmeta AS pm ON p.ID = pm.post_id
JOIN pex_doe_events_eab_booking_meta as bm on bm.booking_id = b.id
WHERE b.user_id = $user_id
GROUP BY b.event_id) as table1
WHERE table1.tickets > 0
 ";
    $bookings = $wpdb->get_results($querystr);

    return $bookings;

}

function bookingDetails()
{
    $bookings = getBookingDetails();
    if ($bookings) {
        ?>
        <div class="um-account-heading">Bookings:</div>
        <?php foreach ($bookings as $booking) {
            $startDob = new Datetime($booking->start_time);
            $endDob = new Datetime($booking->end_time);
            $now = new Datetime();
            if(strtotime($booking->end_time) > time()) {
                ?>
                <div class="kids-details">
                    <div class="booking-name"><strong>Workshop: </strong><?php echo $booking->post_title; ?></div>
                    <div class="booking-start-time"><strong>Start
                            time: </strong><?php echo $startDob->format("d-m-Y H:i"); ?></div>
                    <div class="booking-end-time"><strong>End Time: </strong><?php echo $endDob->format("d-m-Y H:i"); ?> </div>
                    <div class="kids-names">
                        <strong>Kids Attending:</strong>
                        <?php
                        $kids = unserialize($booking->kids);
                        foreach ($kids as $kid) {
                            foreach ($kid['kids_names'] as $kidName) {
                                echo '<br>';
                                echo $kidName ;
                            }
                        }
                        ?>
                    </div>
                </div>
            <?php }
        }
    }
}

add_filter('eab-rsvps-button-no', 'kidsForm', 10);

//add_action('um_post_account_update', 'kidsFormUpdate');

function shortenArray($_arr)
{
    $i=1;
    $_shorter=array();
    foreach ($_arr as $k => $v)
    {
        if ($i != 1)
        {
            $_shorter[$k] = $v;
        }
        $i++;
    }
    return $_shorter;
}


function kidsFormUpdate()
{
    global $post;

    $user_id = get_current_user_id();
    $userData = get_user_meta($user_id);
    $submittedData = $userData['submitted'][0];

    $decodedData = unserialize($submittedData);
    $kidsData = $decodedData['acf']['field_5804a636e4538'];
    $repeater = get_field('kids_details', 'user_' . $user_id, false, false);
    if ($repeater) {
        $results = array_merge($kidsData, $repeater);
        $decodedData['acf']['field_5804a636e4538'] = $results;
        update_user_meta($user_id, 'submitted', $decodedData);
    }

}

function kidsForm($content)
{
    if(!isset($_SESSION)){
        session_start();
    }

    global $post;
    if (is_user_logged_in()) {

        $user_id = get_current_user_id();
        $userData = get_user_meta($user_id);
        $submittedData = $userData['submitted'];
        $data = $submittedData[0];
        $decodedData = unserialize($data);
        $kidsData = $decodedData['acf']['field_5804a636e4538'];
        
        $acfData = get_fields('user_' . $user_id);
        
        if ($acfData) {
            
            $acform = '<h3>Please select what children will be attending this event:</h3><br><br>';

            $categories = get_the_terms($post->ID, 'eab_events_category');      

            $output = '';
            if (!empty($categories)) {
                foreach ($categories as $category) {
                    $output = $category->slug;
                }
            }      
            
            $meta = get_post_meta($post->ID);
            $eventDate = new DateTime($meta['incsub_event_start'][0]);
            
            foreach ($acfData['kids_details'] as $key => $childData) {

                $dob = DateTime::createFromFormat('d/m/Y h:i', $childData['kids_dob'].'00:00');
                $interval = $eventDate->diff($dob);
                $age = $interval->y;

                $canAttend = false;
                if ($output == '10-14-workshop') {
                    if ($age >= 10 && $age <= 14) {
                        $canAttend = true;
                    }
                } elseif ($output == '6-14-workshop') {
                    if ($age >= 6 && $age <= 14) {
                        $canAttend = true;
                    }
                } else{
                    $canAttend = true;
                }

                if($canAttend){
                    $acform .= '<label class="checkbox"><input type="checkbox" name="kids_name-' . $key . '" value="' . $childData['kids_name'] . '">' . $childData['kids_name'] . '</label> ';
                    }
                    else{
                    $acform .= '<label class="checkbox" title="Child will not be the correct age for this event"><input type="checkbox" disabled name="kids_name-' . $key . '" value="' . $childData['kids_name'] . '">' . $childData['kids_name'] . '</label> ';
                    }
            }     
            $acform .= '<br/>';       
        }
    }
    return $acform . $content;
}

add_action('incsub_event_booking_yes', 'incsub_event_booking_yes_cb', 5, 2);


function incsub_event_booking_yes_cb($event_id, $user_id) {
    global $wpdb, $post;
    $kidsNames = [];

    $i = 0;
    foreach ($_POST as $postKey => $postValue) {
        $firstPart = explode('-', $postKey)[0];
        if ($firstPart == 'kids_name') {
            $kidsNames[] = $postValue;
            $i++;
        }
    }

    $user = get_current_user_id();
    $temp[] = array(
        'user_id' => $user,
        'kids_names' => $kidsNames
    );
    $_SESSION['countKids'] = $i;
    $kidsData = serialize($temp);

    $booking_query = (int)$wpdb->get_var("SELECT id FROM pex_doe_events_eab_bookings WHERE event_id = '$event_id' AND user_id = '$user'");

    //Replace not working, unable to change key with existing duplicates
    $wpdb->delete(
        'pex_doe_events_eab_booking_meta',
        array (
            'booking_id' => $booking_query,
            'meta_key' => 'children_attending'
        ));
        
            $wpdb->replace (
                'pex_doe_events_eab_booking_meta',
                array (
                    'booking_id' => $booking_query,
                    'meta_key' => 'children_attending',
                    'meta_value'=> serialize($temp)
                )
    );
    //update_post_meta($booking_query, 'childrenAttending', $temp);
}


add_action('add_meta_boxes', 'ev_add_meta_box');
function ev_add_meta_box()
{
    add_meta_box(
        'ev_sp_req',
        'Kids Attending:',
        'sp_req_callback',
        'incsub_event',
        'advanced',
        'high'
    );
}

function sp_req_callback($post) {
    global $wpdb;
    //$kidsData = get_post_meta($post->ID, 'childrenAttending', true);
    $kidsQuery = "
        SELECT b.user_id, booking_id,
        MAX(CASE WHEN meta_key = 'children_attending' THEN meta_value END)as 'kids',
        MAX(CASE WHEN meta_key = 'booking_transaction_key' THEN meta_value END)as 'booking'
        FROM pex_doe_events_eab_booking_meta AS bm 
        JOIN pex_doe_events_eab_bookings AS b ON b.id = bm.booking_id
        WHERE b.event_id = '$post->ID'
        GROUP BY bm.booking_id
 ";
    $kidsData = $wpdb->get_results($kidsQuery);
    $html = '<table cellpadding="5" cellspacing="5" width="100%" id="kidsAttending">';

    $extraKids = get_field('kids_names', $post->ID);
    $html .= '<tr>';
    $html .= '<th width="20%" style="text-align: left">Username';
    $html .= '</th>';
    $html .= '<th style="text-align: left">Kids Attending:';
    $html .= '</th>';
    $html .= '<th style="text-align: left">In Attendance?';
    $html .= '</th>';
    $html .= '</tr>';
    $kidsAttending = unserialize(get_post_meta($post->ID, 'kidsAttending', true ));

    if ($extraKids) {
        $kidsData = array_merge($kidsData, $extraKids);
    }

    foreach ($kidsData as $parentUser) {
        $testBooking = array_key_exists('booking', $parentUser);

        if (array_key_exists('booking', $parentUser) && $parentUser->booking != NUll || $testBooking == false) {
            $html .= '<tr>';
            $html .= '<td>';
            if (array_key_exists('user_id', $parentUser)) {
                $user_info = get_userdata($parentUser->user_id);
                if ($user_info) {
                    $html .= $user_info->display_name . ' (' . $user_info->user_login . ')';
                }
            }elseif (array_key_exists('kids_name', $parentUser)) {
                $html .= 'N/A';
            }
            $html .= '</td>';
            $html .= '<td>';
            if (array_key_exists('kids', $parentUser)) {
                $childNames = unserialize($parentUser->kids);
                if ($childNames) {
                    foreach ($childNames[0]['kids_names'] as $childData) {
                        $html .= $childData . '<br/>';
                    }
                }
            } elseif (array_key_exists('kids_name', $parentUser)) {
                $html .= $parentUser['kids_name'];
            }
            $html .= '</td>';
            $html .= '<td>';
            if (array_key_exists('kids', $parentUser)) {
                if ($childNames[0]['kids_names']) {
                    foreach ($childNames[0]['kids_names'] as $childData) {
                        if (in_array($childData, $kidsAttending)) {
                            $html .= '<input type="checkbox" name="kidsNames[]" value="' . $childData . '" checked /><br/>';
                        } else {
                            $html .= '<input type="checkbox" name="kidsNames[]" value="' . $childData . '" /><br/>';
                        }
                    }
                }
            } elseif (array_key_exists('kids_name', $parentUser)) {
                $html .= '<input type="checkbox"  name="kidsNames[]" value="' . $parentUser['kids_name'] . '" checked /><br/>';
            }
            $html .= '</td>';
            $html .= '</tr>';
        }
    }
    $html .= '</table>';
    echo $html;

}

function save_events_meta( $post_id, $post, $update ) {
    global $wpdb;
    if ( isset( $_POST['kidsNames'] ) ) {
        update_post_meta( $post_id, 'kidsAttending',  maybe_serialize($_POST['kidsNames']) );
    }


    if ( isset( $_POST['acf'] ) && $_POST['acf']['field_5a0c07c3d77f3'] !== '' ) {

        $extraKids = serialize($_POST['acf']);
        $booking_query = (int)$wpdb->get_var("SELECT id FROM pex_doe_events_eab_bookings WHERE event_id = '$post_id' AND user_id = '9999'");

        if ($booking_query != 0 ) {

            $extraKidsId = get_booking_meta_id($booking_query, 'extraKids');
            $wpdb->replace(
                'pex_doe_events_eab_booking_meta',
                array(
                    'id' => $extraKidsId,
                    'booking_id' => $booking_query,
                    'meta_key' => 'extraKids',
                    'meta_value' => $extraKids
                )
            );

            $booking_transaction_keyId = get_booking_meta_id($booking_query, 'booking_transaction_key');
            $wpdb->replace(
                'pex_doe_events_eab_booking_meta',
                array(
                    'id' => $booking_transaction_keyId,
                    'booking_id' => $booking_query,
                    'meta_key' => 'booking_transaction_key',
                    'meta_value' => serialize([])
                )
            );
            $booking_ticket_countId = get_booking_meta_id($booking_query, 'booking_ticket_count');
            $res= $wpdb->replace(
                'pex_doe_events_eab_booking_meta',
                array(
                    'id' => $booking_ticket_countId,
                    'booking_id' => $booking_query,
                    'meta_key' => 'booking_ticket_count',
                    'meta_value' => count($_POST['acf']['field_5a0c07c3d77f3'])
                )
            );

        } else {

            $wpdb->insert(
                'pex_doe_events_eab_bookings',
                array(
                    'event_id' => $post_id,
                    'user_id' => '9999',
                    'timestamp' => date("Y-m-d H:i:s"),
                    'status' => 'yes'
                )
            );

            $booking_id = $wpdb->insert_id;

            $wpdb->insert(
                'pex_doe_events_eab_booking_meta',
                array(
                    'booking_id' => $booking_id,
                    'meta_key' => 'extraKids',
                    'meta_value' => $extraKids
                )
            );
            $wpdb->insert(
                'pex_doe_events_eab_booking_meta',
                array(
                    'booking_id' => $booking_id,
                    'meta_key' => 'booking_transaction_key',
                    'meta_value' => serialize([])
                )
            );
            $wpdb->insert(
                'pex_doe_events_eab_booking_meta',
                array(
                    'booking_id' => $booking_id,
                    'meta_key' => 'booking_ticket_count',
                    'meta_value' => count($_POST['acf']['field_5a0c07c3d77f3'])
                )
            );
        }
    }
}

add_action( 'save_post', 'save_events_meta', 10, 3 );

function get_booking_meta ($booking_id, $meta_key, $default=false) {
    $booking_id = (int)$booking_id;
    if (!$booking_id) return $default;

    global $wpdb;
    $meta_value = $wpdb->get_var($wpdb->prepare("SELECT meta_value FROM pex_doe_events_eab_booking_meta WHERE booking_id = %d AND meta_key = %s;", $booking_id, $meta_key));
    return $meta_value ? $meta_value : $default;
}

function get_booking_meta_id ($booking_id, $meta_key, $default=false) {
    $booking_id = (int)$booking_id;
    if (!$booking_id) return $default;

    global $wpdb;
    $id = $wpdb->get_var($wpdb->prepare("SELECT id FROM pex_doe_events_eab_booking_meta WHERE booking_id = %d AND meta_key = %s;", $booking_id, $meta_key));
    return $id ? $id : $default;
}

function my_eab_inject_export_columns($row, $event, $booking, $user){
    $kids = $event->get_booking_meta($booking->id, 'children_attending');
    $childNames = unserialize($kids);

    $extraKids = $event->get_booking_meta($booking->id, 'extraKids');
    $extraChildNames = unserialize($extraKids);

    $kid="";

    if ($childNames || $extraChildNames) {
        foreach ($childNames[0]['kids_names'] as $childData) {
            if ($childData) {
                $kid .= $childData . "\n";
            }
        }
        foreach ($extraChildNames as $extraKid) {
            foreach ($extraKid as $kidName) {
                if($kidName) {
                    $kid .= $kidName['field_5a0c07cfd77f4']."\n";
                }
            }
        }
        $fields = array(
            'Childrens Names' => $kid,
        );

        foreach ($fields as $key => $value) {
            $row[$key] = $value;
        }

        return $row;
    }
}

add_filter('eab-exporter-csv-row', 'my_eab_inject_export_columns', 10, 4);


add_action('admin_enqueue_scripts', 'custom_admin_scripts');
function custom_admin_scripts()
{
    wp_enqueue_script('admin-scripts', get_stylesheet_directory_uri() . '/assets/js/admin-edits.js', array('jquery'), '1.0', true);
}

function get_number_kids($post_ID) {
    global $wpdb, $post;
    $kidsQuery = "
        SELECT b.user_id, booking_id,
        MAX(CASE WHEN meta_key = 'children_attending' THEN meta_value END)as 'kids',
        MAX(CASE WHEN meta_key = 'booking_transaction_key' THEN meta_value END)as 'booking',
        MAX(CASE WHEN meta_key = 'booking_ticket_count' THEN meta_value END)as 'booking_count',
        b.status
        FROM pex_doe_events_eab_booking_meta AS bm 
        JOIN pex_doe_events_eab_bookings AS b ON b.id = bm.booking_id
        WHERE b.event_id = '$post->ID'
        AND b.status = 'yes'
        GROUP BY bm.booking_id
 ";
    $kidsData = $wpdb->get_results($kidsQuery);

    $sum = 0;
    foreach ($kidsData as $kidsCount) {

        $sum+= $kidsCount->booking_count;
    }
    echo $sum;
}

// ADD NEW COLUMN
function kids_column_head($defaults)
{
    $defaults['childrenAttending'] = 'Children Attending:';
    return $defaults;
}

// SHOW THE FEATURED IMAGE
function kids_column_content($column_name, $post_ID)
{
    if ($column_name == 'childrenAttending') {
        $postKids = get_number_kids($post_ID);
        if ($postKids) {
            //echo $postKids;
        }
    }
}

add_filter('manage_incsub_event_posts_columns', 'kids_column_head', 99);
add_action('manage_incsub_event_posts_custom_column', 'kids_column_content', 10, 2);

//add_action('manage_incsub_event_posts_custom_column', array($this, 'manage_posts_custom_column'));
//add_filter('manage_incsub_event_posts_columns', array($this, 'manage_posts_columns'), 99);

//add_filter('eab-rsvps-button-maybe', 'paid_attendees_email');

function paid_attendees_email()
{
    global $wpdb, $post;
    $query = "
        SELECT u.ID, user_email,
        MAX(CASE WHEN pm.meta_key = 'incsub_event_start' THEN pm.meta_value END)as 'start_date',
        MAX(CASE WHEN bm.meta_key = 'booking_transaction_key' THEN bm.meta_value END)as 'paid'
        FROM pex_doe_events_users AS u 
        JOIN pex_doe_events_eab_bookings AS ub ON u.ID = ub.user_id
        JOIN pex_doe_events_postmeta AS pm ON ub.event_id = pm.post_id
        JOIN pex_doe_events_eab_booking_meta AS bm ON ub.id = bm.booking_id
        GROUP BY u.ID
    ";
    $attendeeData = $wpdb->get_results($query);

    foreach ($attendeeData as $attendee) {

        $startDate = new Datetime($attendee->start_date);

        $now = new Datetime('now');
        $interval = $now->diff($startDate);
        $timeToEvent = $interval;
        $daysToEvent = $timeToEvent->days;

        if ($daysToEvent <= 2 && $daysToEvent != 0) {
            $to = $attendee->user_email;
            $subject = 'Workshop Reminder';
            $body = 'Hi,' . '<br>';
            $body .= "This is just a reminder email to let you know that you are booked onto a workshop in the next couple of days." . '<br>';
            $body .= "Remember you can view all your bookings and times on your account page at www.dinos.dynamos.co.uk/account" . '<br>';
            $body .= "Best regards, Dinos" . '<br>';
            $headers = array('Content-Type: text/html; charset=UTF-8');
            wp_mail($to, $subject, $body, $headers);
        }
    }
}

add_action( 'my_daily_event',  'paid_attendees_email' );

function activate() {
    wp_schedule_event( time(), 'daily', 'my_daily_event' );
}

function deactivate() {
    wp_clear_scheduled_hook('my_daily_event');
}

add_filter('export_users_button', 'export_user_data');

function export_user_data() {
    ?>
    <form name="export-users" method="post" action="">
        <input value="Export" name='user-submit' type="submit">
    </form>
    <?php
    if (isset($_POST['user-submit'])) {
        global $wpdb;
        // Build your query
        $myQuery = $wpdb->get_results("SELECT u.ID, u.user_email, u.user_registered,
 				MAX(CASE WHEN um.meta_key = '_um_last_login' THEN meta_value END)as 'last_login', 
                MAX(CASE WHEN um.meta_key = '_expire_user_expired' THEN meta_value END)as 'user_expired',
				MAX(CASE WHEN um.meta_key = '_expire_user_date' THEN meta_value END)as 'user_expired_date'
            FROM pex_doe_events_users as u
            JOIN pex_doe_events_usermeta AS um ON u.ID = user_id
            GROUP BY u.ID");
        ob_end_clean();

        $out = fopen('php://output', 'w');

        $filename = 'user-export-' . date('Ymd-His') . '.csv';
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header('Content-Description: File Transfer');
        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename={$filename}");
        header("Expires: 0");
        header("Pragma: public");

        fputcsv($out, array('Email', 'Year Registered', 'Renewed', 'Last Logged in', 'Expired', 'Kids Name', 'Kids Address1', 'Kids Address2', 'Town/City', 'Postcode', 'Kids Date of Birth'), ',');
        foreach ($myQuery as $kidsQuery) {

            $lastLogin = $kidsQuery->last_login;
            $expireDate = $kidsQuery->user_expired_date;

            if ($expireDate && $lastLogin > $expireDate ) {
                $userStatus = 'Renewed this year';
            } elseif ($expireDate && $lastLogin < $expireDate ){
                $userStatus = 'Not renewed';
            } else {
                $userStatus = '';
            }
            
            $kidsExport = [];

            $acfData = get_fields('user_' . $kidsQuery->ID);

            if(count($acfData['kids_details'])){

            foreach($acfData['kids_details'] as $kidData){                
                    $kidsExport = array(
                        $kidsQuery->user_email, //Email
                        date("d.m.Y", strtotime($kidsQuery->user_registered)), //Year Registered
                        $userStatus, //Renewed
                        date("d.m.Y", $kidsQuery->last_login),//Last Logged In
                        $kidsQuery->user_expired,//Expired
                        $kidData['kids_name'], //Kids Name
                        $alteredKidddress = $kidData['kids_address'], //Kids Address1
                        $alteredKidddres2 = $kidData['kids_address_2'], //Kids Address2
                        $town = $kidData['town'], //Town/City
                        $postcode = $kidData['postcode'], //Postcode
                        $kidDOB = $kidData['kids_dob'] //Kids Date of Birth
                    );
                    fputcsv($out, $kidsExport);
                }
            }
            else{            
                $kidsExport = array(
                    $kidsQuery->user_email, //Email
                    date("d.m.Y", strtotime($kidsQuery->user_registered)), //Year Registered
                    $userStatus, //Renewed
                    date("d.m.Y", $kidsQuery->last_login),//Last Logged In
                    $kidsQuery->user_expired,//Expired
                    '', //Kids Name
                    '', //Kids Address1
                    '', //Kids Address2
                    '', //Town/City
                    '', //Postcode
                    '' //Kids Date of Birth
                );
                fputcsv($out, $kidsExport);
            }

           /* if ($kidsQuery->kids_data != "") {
                $kidsData = unserialize($kidsQuery->kids_data);
                if ($kidsData['acf']) {
                    $kidsDetails = $kidsData['acf'];
                    if ($kidsDetails['field_5804a636e4538']) {
                        $kids = $kidsDetails['field_5804a636e4538'];
                        foreach ($kids as $kidData) {
                            if ($kidData['field_5804a641e4539'] != "") {
                                $kidsExport = array(
                                    $kidsQuery->user_email,
                                    date("d.m.Y", strtotime($yearRegistered)),
                                    $userStatus,
                                    $kidData['field_5804a641e4539'],
                                    $alteredKidddress = $kidData['field_5804a647e453a'],
                                    $alteredKidddres2 = $kidData['field_58ca7a1c09a1b'],
                                    $town = $kidData['field_58ca7a3909a1c'],
                                    $postcode = $kidData['field_58ca7a4909a1d'],
                                    $kidDOB = $kidData['field_5809cd60d0e2a']
                                );
                                fputcsv($out, $kidsExport);
                            }
                        }
                    }
                }
            }*/
        }
        fclose($out);
        exit;
    }
}

function add_user_export() {
    wp_add_dashboard_widget(
        'user_export',         // Widget slug.
        'Export users',         // Title.
        'export_user_data' // Display function.
    );
}
add_action( 'wp_dashboard_setup', 'add_user_export' );

function register_kidCount_session() {
    if(!session_id()) {
        session_start();
    }
}

add_action('init', 'register_kidCount_session');

add_filter( 'mp_cart/no_items_message', 'custom_no_items_message' );
function custom_no_items_message() {
    $message = sprintf( __( '<p class="cart-message">Cart is empty</p>', 'mp' ) );

    return $message;
}

remove_all_actions('incsub_event_booking_yes', 10);

add_action('incsub_event_booking_yes',  'add_event_qty_to_cart', 20, 2);
function add_event_qty_to_cart($event_id, $user_id) {
    // if (!$this->_is_mp_present()) return;

    $event = new Eab_EventModel(get_post($event_id));
    $recurring = $event->is_recurring_child();
    $product_id = false;

    if ($recurring) {
        $parent_product_id = get_post_meta($recurring, 'eab_product_id', true);
        $query = new WP_Query(array(
            'post_type' => apply_filters( 'mp_product_variation_post_type', 'mp_product_variation' ),
            'posts_per_page' => 1,
            'post_parent' => $parent_product_id,
            'meta_query' => array(array(
                'key' => 'sku',
                'value' => $event_id
            )),
            'fields' => 'ids'
        ));
        $product_id = !empty($query->posts[0]) ? $query->posts[0] : false;
    } else {
        $product_id = get_post_meta($event_id, 'eab_product_id', true);
    }

    if (!$product_id) return;

    $cart = MP_Cart::get_instance();
    $items = $cart->get_items();
    $qty = $_SESSION['countKids'];
    if (is_array($items) && false === array_search($product_id, array_keys($items))) {
        $product = new MP_Product( $product_id );
        if( $product->has_variations() ) {
            $cart->add_item( $_POST['action_variation'], $qty);
        }else{
            $cart->add_item( $product_id , $qty);
        }
    }
}
