<?php
/**
 * Hero Intro Section
 *
 * Flexible content section for 'hero_intro' section.
 *
 * @todo form functionality
 *
 * @package DVVA_Theme
 */

$title = get_sub_field('title');
$image = get_sub_field('image');

?>

<section class="s-heroIntro flex-column ff-title">
    <div class="s-heroIntro__contain contain">
        <div class="row">
            <div class="col-12 col-lg-7 flow">
                <h1 class="s-heroIntro__title fw-extrabold"><?= $title; ?></h1>

                <form class="s-heroIntro__form flow" id="intro-form">
                    <label>
                        I want to
                        <select class="s-heroIntro__select" name="volunteering-option" id="option">
                            <option default value="volunteer">Volunteer</option>
                            <option value="find-a-volunteer">Find a Volunteer</option>
                        </select>
                    </label>

                    <button class="s-heroIntro__getStarted b-button" type="submit" data-style="fill">
                        <span class="b-button__text">Get Started</span>
                        <span class="b-button__icon fal fa-long-arrow-right"></span>
                    </button>
                </form>
            </div>
        </div>
    </div>

    <div class="s-heroIntro__imgWrap">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 1430 1094" width="1430" height="1094" preserveAspectRatio="xMaxYMid slice" class="s-heroIntro__img" role="presentation">
            <defs>
                <path id="hero-shape" d="M767 717.5a24 24 0 01-21-35.5l162.6-291.7a24 24 0 0141.8 0L1113 682a24 24 0 01-21 35.5zm390.6-13.6L995.1 412.2a24 24 0 0120.8-35.5h325.2a24 24 0 0120.9 35.5L1199.4 704a24 24 0 01-41.8 0zm-494 0L501.1 412.2a24 24 0 0120.9-35.5H847a24 24 0 0120.9 35.5L705.4 704a24 24 0 01-41.8 0z"/>
            </defs>
            <clipPath id="hero-mask">
                <use xlink:href="#hero-shape"/>
            </clipPath>
            <?php if ($image) { ?>
                <use xlink:href="#hero-shape" fill="#decbe1"/>
                <image href="<?= $image['url']; ?>" x="498.165" y="376.7" width="866.77" height="340.8" clip-path="url(#hero-mask)" preserveAspectRatio="xMidYMid slice"/>
            <?php } else { ?>
                <use xlink:href="#hero-shape" fill="#7b2c87"/>
            <?php } ?>
            <path d="M414.6 390.3a24 24 0 0141.8 0L619 682a24 24 0 01-20.9 35.5H273a24 24 0 01-21-35.5zM1409.6 390.2c4.6-8.2 12-12.2 20.4-12.2v339.5h-162a24 24 0 01-21-35.6z" fill="#f39118"/>
            <path d="M1160.6 25.5a24 24 0 0141.8 0L1365 317.2a24 24 0 01-20.9 35.6H1019a24 24 0 01-21-35.6zM663.6 25.5a24 24 0 0141.8 0L868 317.2a24 24 0 01-20.9 35.6H522a24 24 0 01-21-35.6z" fill="#7b2c87"/>
            <path d="M1430 339.5c-8 .2-15.7-3.9-20.4-12.3L1247.1 35.6A24 24 0 011268 0h162zM953.4 327.2a24 24 0 01-41.8 0L749.1 35.6A24 24 0 01769.9 0h325.2a24 24 0 0120.9 35.6z" fill="#00a3b9"/>
            <path d="M1160.6 766.8a24 24 0 0141.8 0l162.6 291.7a24 24 0 01-20.9 35.5H1019a24 24 0 01-21-35.5z" fill="#7b2c87"/>
            <path d="M1430 1080.8a23.4 23.4 0 01-20.4-12.3l-162.5-291.7a24 24 0 0120.9-35.5h161c0 41.8 1 293.1 1 339.5z" fill="#00a3b9"/>
            <path d="M663.6 766.8a24 24 0 0141.8 0L868 1058.5A24 24 0 01847 1094H522a24 24 0 01-21-35.5z" fill="#7b2c87"/>
            <path d="M953.4 1068.5a24 24 0 01-41.8 0L749.1 776.8a24 24 0 0120.8-35.5h325.2a24 24 0 0120.9 35.5z" fill="#00a3b9"/>
            <path d="M165.6 766.8a24 24 0 0141.8 0L370 1058.5A24 24 0 01349 1094H24a24 24 0 01-21-35.5z" fill="#7b2c87"/>
            <path d="M456.4 1068.5a24 24 0 01-41.8 0L252.1 776.8a24 24 0 0120.8-35.5h325.2a24 24 0 0120.9 35.5z" fill="#00a3b9"/>
        </svg>
    </div>
</section>
