<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>

    <div class="row">
        <div class="col-lg-8">

            <h1><?php the_title(); ?></h1>
            <?php the_content(); ?>

            <a href="<?php
            $add_to_cart = do_shortcode('[add_to_cart_url id="'.$post->ID.'"]');
            echo $add_to_cart;
            ?>" class="more">Buy now</a>

            <?php
            $terms = get_the_terms(get_the_id(), 'product_cat');
            $bookingTerms = false;

            if($terms[0]->slug == 'dvva-members-rooms' || $terms[0]->slug == 'rooms') {
                $bookingTerms = get_field('booking_terms_rooms', 'option');
            } elseif($terms[0]->slug == 'dvva-members-equipment' || $terms[0]->slug == 'equipment') {
                $bookingTerms = get_field('booking_terms_equipment', 'option');
            } elseif($terms[0]->slug == 'dvva-members-resources' || $terms[0]->slug == 'resources') {
                $bookingTerms = get_field('booking_terms_resources', 'option');
            }

            if($bookingTerms) { ?>
                <div class="booking-terms">
                    <h3 class="title">Booking Terms</h3>
                    <div class="terms"><?= $bookingTerms; ?></div>
                </div>
            <?php } ?>

        </div>
        <div class="col-lg-4 d-flex justify-content-center">
            <?php
            /**
             * Hook: woocommerce_before_single_product_summary.
             *
             * @hooked woocommerce_show_product_sale_flash - 10
             * @hooked woocommerce_show_product_images - 20
             */
            do_action( 'woocommerce_before_single_product_summary' );
            ?>
        </div>
    </div>


	<div class="summary entry-summary">

	</div>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
