<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );
?>
    <main class="l-main">

        <?php get_template_part('templates/parts/titlebar', null, [
            'title' => 'Book',
            'description' => get_field('shop_archive_description', 'option')
        ]); ?>

        <div class="contain">
            <?php
            $productCategories = get_terms('product_cat');
            $count = count($productCategories);
            if ( $count > 0 ) {
                foreach ($productCategories as $productCategory) {
                    $args = [
                        'posts_per_page' => -1,
                        'tax_query' => [
                            'relation' => 'AND',
                            [
                                'taxonomy' => 'product_cat',
                                'field' => 'slug',
                                'terms' => $productCategory->slug
                            ]
                        ],
                        'post_type' => 'product',
                        'orderby' => 'title,'
                    ];
                    $products = new WP_Query($args);
                    ?>
                    <div class="product-category-section">
                        <h2><?= $productCategory->name; ?></h2>

                        <div class="product-output">
                            <div class="row">
                                <?php while ($products->have_posts()) {
                                    $products->the_post();
                                    $image = \Blue2\Scruffy\Site::getPostImage(get_the_id());
                                    ?>
                                    <div class="col-sm-6 col-md-4 col-xl-3 dvva-product-col">
                                        <a href="<?php the_permalink(); ?>">
                                            <div class="image-wrapper <?= $image['class']; ?>">
                                                <?= $image['item']; ?>
                                            </div>
                                            <div class="content-wrapper">
                                                <div class="title"><?php the_title(); ?></div>
                                                <div class="price">£5.00 <span class="frequency">/ day</span></div>
                                            </div>
                                        </a>
                                    </div>
                                    <?php
                                } wp_reset_postdata(); ?>
                            </div>
                        </div>
                    </div>
                    <?php
                }
            }
            ?>
        </div>
    </main>
<?php
get_footer( 'shop' );
