<?php
/**
 * Site Header
 *
 * Includes header bar, navigation
 *
 * @package DVVA_Theme
 */

?>

<header class="l-header ff-title" data-state="closed">
    <div class="l-header__contain contain">
        <a class="l-header__brand" href="<?php echo esc_url(home_url('/')); ?>">
            <?php
            $path = get_template_directory() . '/dist/images/dvva-logo.svg';
            $file = file_get_contents($path);

            // remove xml header
            $file = str_replace(
                '<?xml version="1.0" encoding="UTF-8"?>',
                '',
                $file
            );

            // add class and attributes for accessibility
            echo str_replace(
                '<svg',
                '<svg class="l-header__logo" role="img" aria-label="Dundee Volunteer and Voluntary Action"',
                $file
            );
            ?>
        </a>

        <nav class="l-header__nav l-nav">

            <button
                id="nav-toggle"
                type="button"
                class="l-nav__toggle b-navToggle"
                data-state="closed"
                aria-controls="primary-nav"
                aria-expanded="false"
                aria-label="Open primary navigation">
                <div class="b-navToggle__burger">
                    <span class="b-navToggle__bar"></span>
                    <span class="b-navToggle__bar"></span>
                    <span class="b-navToggle__bar"></span>
                </div>
            </button>

            <div class="l-nav__wrap" id="primary-nav" data-state="closed">
                <?php if (has_nav_menu('primary')) {
                    wp_nav_menu([
                        'theme_location'    => 'primary',
                        'menu_container'    => 'ul',
                        'menu_class'        => 'l-nav__menu',
                        'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                    ]);
                } ?>

                <div class="l-nav__btns">
                    <a class="l-nav__btn l-nav__btn--big" href="/book/">
                        Book a room
                    </a>

                    <a class="l-nav__btn l-nav__btn--big" href="/become-a-member/">
                        Become a member
                    </a>

                    <a class="l-nav__btn l-nav__btn--icon" href="#0" aria-label="Member Login">
                        <span class="l-nav__btnIcon fas fa-user"></span>
                        <span class="l-nav__btnText">Member Login</span>
                    </a>

                    <a class="l-nav__btn l-nav__btn--icon" href="#0" aria-label="Search">
                        <span class="l-nav__btnIcon fas fa-search"></span>
                        <span class="l-nav__btnText">Search</span>
                    </a>
                </div>
            </div>
        </nav>
    </div>
</header>
