<?php
/**
 * Meet the Team Section
 *
 * Flexible content section for 'team' section.
 *
 * @package DVVA_Theme
 */

$team = get_sub_field('team');

?>
<?php if ($team) { ?>
    <section class="s-team fs-7 lh-sm">
        <div class="contain">
            <div class="row">
                <?php foreach ($team as $person) { ?>
                    <div class="col-12 col-sm-6 col-lg-4 col-xl-3">
                        <?= \Blue2\Scruffy\Utils::acf_img($person['image']); ?>

                        <h2 class="fs-inherit fw-bold mt-3"><?= $person['name']; ?></h2>
                        <p><?= $person['job_title']; ?></p>

                        <?php if ($person['email']) { ?>
                            <a class="text-theme text-decoration-none" href="mailto:<?= sanitize_email($person['email']); ?>">
                                <span class="fas fa-envelope" aria-hidden="true"></span>
                                <?= $person['email']; ?>
                            </a>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php }
