<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\ContactForm7;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'primary'   => 'Main Menu',
            'secondary' => 'Footer Menu 1',
            'tertiary'  => 'Footer Menu 2'
        ]);
    }

    private function registerShortCodes()
    {
        add_shortcode('b2_button', [$this, 'buttonShortcode']);
        add_shortcode('b2_videos', [$this, 'videosShortcode']);
    }

    private function registerFilters()
    {
        // page theme
        add_filter('body_class', [$this, 'pageTheme']);

        // contact form 7
        add_filter('wpcf7_autop_or_not', '__return_false');
        add_filter('wpcf7_load_css', '__return_false');

        // acf google maps api
        add_filter('acf/fields/google_map/api', function ($api) {
            $api['key'] = 'AIzaSyCg0WHUkWcjFIm3IRx9ehMAkq98NU3TN1E';
            return $api;
        });

    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'registerTaxonomies']);
    }

    private function setupControllers()
    {
        new ContactForm7;
    }

    public function registerPostTypes()
    {
        Post\VoluntaryJob::registerPostType();
    }

    public function registerTaxonomies()
    {
        new Taxonomy\Age();
        new Taxonomy\Service();
        new Taxonomy\SpecialistRole();
        new Taxonomy\Theme();
    }

    /**
     * pageTheme
     *
     * Adds class to body setting the 'theme' colour of the page
     *
     * @return array array of body classes
     */
    public function pageTheme($classes)
    {
        $theme = get_field('theme_colour');
        if ($theme) {
            $classes[] = 'theme-' . $theme;
        }

        return $classes;
    }

    /**
     * buttonShortcode
     *
     * @param  array $atts
     * @return string
     */
    public function buttonShortcode($atts = [])
    {
        // check there are at least two attributes
        if (count($atts) < 2) return;

        $label = $atts[0];
        $url = $atts[1];

        return sprintf(
            '<a class="b-button" href="%s">%s</a>',
            esc_url($url),
            esc_html($label)
        );
    }

    public function videosShortcode($atts = [])
    {
        $video_html = array_map(function ($id) {
            return '
            <div class="b-videos__col col-12 col-md-6">
                <div class="b-videos__wrap">
                    <iframe
                        class="b-videos__el"
                        width="560"
                        height="315"
                        src="https://www.youtube.com/embed/' . $id . '"
                        srcdoc="<style>*{padding:0;margin:0;overflow:hidden}html,body{height:100%}img,span{position:absolute;width:100%;top:0;bottom:0;margin:auto}span{height:1.5em;text-align:center;font:48px/1.5 sans-serif;color:white;text-shadow:0 0 0.5em black}</style><a href=https://www.youtube.com/embed/' . $id . '?autoplay=1><img src=https://img.youtube.com/vi/' . $id . '/hqdefault.jpg alt=\'\'><span>&#x25BA;</span></a>"
                        frameborder="0"
                        allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen
                        loading="lazy"
                    ></iframe>
                </div>
            </div>';
        }, $atts);

        return '<div class="b-videos row">' . implode('', $video_html) . '</div>';
    }
}
