<?php
/**
 * Content Section
 *
 * Flexible content section for 'content' section.
 *
 * @package DVVA_Theme
 */

$id = get_sub_field('id');
$content = get_sub_field('content');
$sidebar = get_sub_field('sidebar');

?>

<section
    <?= $id ? 'id="' . $id . '"' : '' ?>
    class="s-content lh-sm">

    <?php if ($sidebar === 'decoration') {
        Blue2\Scruffy\Utils::symbol('shape-right', 's-content__decoration');
    } ?>

    <div class="contain">
        <div class="s-content__main">
            <div class="row justify-content-between">
                <div class="col-12 col-lg-7 flow">
                    <?= $content; ?>
                </div>

                <?php if ($sidebar && $sidebar !== 'decoration') { ?>
                    <div class="col-12 col-lg-4">
                        <?php switch ($sidebar) {
                            case 'image':
                                $image = get_sub_field('image');
                                echo \Blue2\Scruffy\Utils::acf_img($image, [
                                    'class' => 's-content__img'
                                ]);
                                break;

                            case 'html':
                                the_sub_field('html');
                                break;
                        } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
