<?php
/**
 * Link Block Part
 *
 * Used within 'link_block' section and on a few templates
 *
 * @package DVVA_Theme
 */

$cols = get_field('link_block', 'options');

?>

<section class="s-linkBlock bg-theme text-white" data-full>
    <?php Blue2\Scruffy\Utils::symbol('shape-left', 's-linkBlock__dec s-linkBlock__dec--left'); ?>
    <?php Blue2\Scruffy\Utils::symbol('shape-right', 's-linkBlock__dec s-linkBlock__dec--right'); ?>
    <div class="contain">
        <div class="s-linkBlock__row row">
            <?php foreach ($cols as $col) {
                if (!$col) continue;
                ?>
                <div class="col-12 col-md-6">
                    <div class="s-linkBlock__wrap flow">
                        <h2>
                            <?= $col['title']; ?>
                        </h2>

                        <?= $col['content']; ?>

                        <?php if ($col['links']) { ?>
                            <ul class="s-linkBlock__links" role="list">
                                <?php foreach ($col['links'] as $link) { ?>
                                    <li class="s-linkBlock__single">
                                        <h3><?= $link['title']; ?></h3>

                                        <?= $link['description']; ?>

                                        <?php if ($link['link'] && $link['link']['url']) {
                                            $label = $link['link']['title'] ?: 'Read more';
                                            ?>
                                            <a href="<?= $link['link']['url']; ?>" class="b-button mt-4 text-theme" data-style="fill" data-colour="inverse" aria-label="<?= $label; ?> about <?= $link['title'] ?>">
                                                <span class="b-button__text"><?= $label; ?></span>
                                                <span class="b-button__icon fal fa-long-arrow-right"></span>
                                            </a>
                                        <?php } ?>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php } ?>

                        <?= $col['footer']; ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</section>
