<?php
/**
 * Titlebar Section
 *
 * Flexible content section for 'titlebar' section.
 *
 * @package DVVA_Theme
 */

$custom_title = get_sub_field('custom_title');
$description= get_sub_field('description');

$title = $custom_title ?: Blue2\Common\Theme\Utils::getTitle();

?>

<section class="s-titlebar text-white bg-theme" data-full>
    <div class="s-titlebar__visible flex-column">
        <?php Blue2\Scruffy\Utils::symbol('shape-left', 's-titlebar__dec s-titlebar__dec--left'); ?>
        <?php Blue2\Scruffy\Utils::symbol('shape-right', 's-titlebar__dec s-titlebar__dec--right'); ?>

        <div class="contain">
            <div class="s-titlebar__content flow">
                <h1 class="s-titlebar__title fw-bold"><?= $title; ?></h1>
                <?php if ($description) { ?>
                    <p class="ff-title fw-light"><?= $description; ?></p>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
