<?php
/**
 * Resources Section
 *
 * Flexible content section for 'resources' section.
 *
 * @package DVVA_Theme
 */

$title = get_sub_field('title');
$content = get_sub_field('content');
$link = get_sub_field('link');
$resources = get_sub_field('resources');

?>

<section class="s-resources text-white bg-primary" data-full>
    <?php Blue2\Scruffy\Utils::symbol('shape-right', 's-resources__decoration'); ?>
    <div class="contain">
        <div class="row">
            <div class="col-12 col-lg-6 pb-4 flex-column align-items-start flow">
                <h2 class="s-resources__title fs-1"><?= $title; ?></h2>
                <?= $content; ?>

                <?php if ($link && $link['url']) { ?>
                    <a href="<?= $link['url']; ?>" class="s-resources__contentBtn b-button text-primary" data-style="fill" data-colour="inverse">
                        <span class="b-button__text"><?= $link['title'] ?: 'Learn more' ?></span>
                        <span class="b-button__icon fal fa-long-arrow-right"></span>
                    </a>
                <?php } ?>
            </div>

            <div class="col-12 col-lg-6">
                <ul class="s-resources__list" role="list">
                    <?php foreach ($resources as $resource) { ?>
                        <li class="s-resources__single flex-column">
                            <h3 class="s-resources__title">
                                <?= $resource['title']; ?>
                            </h3>

                            <p><?= $resource['description']; ?></p>

                            <?php if ($resource['link'] && $resource['link']['url']) { ?>
                                <a href="<?= $resource['link']['url']; ?>" class="b-button mt-4 ms-auto text-primary" data-style="expand" data-colour="inverse" aria-label="Read more about <?= $resource['title'] ?>">
                                    <span class="b-button__text"><?= $link['title'] ?: 'Read more' ?></span>
                                    <span class="b-button__icon fal fa-long-arrow-right"></span>
                                </a>
                            <?php } ?>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
</section>
