<?php
/**
 * Newsletter Section
 *
 * Flexible content section for 'newsletter' section.
 *
 * @package DVVA_Theme
 */

$title = get_field('newsletter_title', 'options');
$description = get_field('newsletter_description', 'options');
$form = get_field('newsletter_form', 'options');

?>

<section class="s-newsletter" data-full>
    <div class="contain">
        <div class="s-newsletter__main">
            <div class="s-newsletter__contain">
                <div class="s-newsletter__img text-center" aria-hidden="true">
                    <img src="<?= get_template_directory_uri(); ?>/dist/images/newsletter.svg" height="100" width="100" loading="lazy">
                </div>
                <div class="s-newsletter__content">
                    <h2 class="s-newsletter__title fs-5 text-primary fw-bold text-center text-sm-start"><?= $title; ?></h2>
                    <p class="s-newsletter__description"><?= $description; ?></p>
                    <div class="s-newsletter__form mt-4">
                        <?= do_shortcode($form); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
