<?php
namespace Blue2\Scruffy;

class Utils extends \Blue2\Common\Theme\Utils
{
    /**
     * term_list
     *
     * take taxonomy slug and format all terms of current post in string seperated list
     *
     * @param  string $tax taxonomy slug
     * @return string
     */
    public static function term_list($tax)
    {
        return implode(', ', array_column(get_terms($tax), 'name'));
    }

    /**
     * symbol
     *
     * @param  mixed $id
     * @return void
     */
    public static function symbol($id, $class = '')
    {
        $viewboxes = [
            'shape-left'    => '0 0 150.5 267.4',
            'shape-right'   => '0 0 189.7 360'
        ];
        printf(
            '<svg viewBox="%s" class="%s" aria-hidden="true"><use xlink:href="#dvva-symbol-%s"/></svg>',
            $viewboxes[$id] ?? '0 0 100 100',
            $class,
            $id
        );
    }
}
