<?php
/**
 * Archive Template for Voluntary Job CPT
 *
 * For Map options:
 * @see /assets/scripts/google-maps/index.js
 *
 * @todo add search/filtering
 *
 * @package DVVA_Theme
 */

// Get number of total items, number of items on this page, and page number.
global $wp_query;
$total_items = $wp_query->found_posts;
$curr_page = get_query_var('paged') ?: 1;
$total_pages = $wp_query->max_num_pages;

// Run the post loop so we can get location for each item for use in map.
$markers = [];
if (have_posts()) {
    while (have_posts()) {
        the_post();
        $location = get_field('location');
        if ($location['lat'] && $location['lng']) {
            $markers[$wp_query->current_post] = [
                'lat' => $location['lat'],
                'lng' => $location['lng']
            ];
        }
    }
}

// reset post loop for re-use in item list
rewind_posts();

?>

<main class="l-main">
    <section class="sv-archive bg-light fs-7" data-full>

        <div class="sv-archive__mapCol" aria-hidden="true">
            <div class="sv-archive__mapWrap">
                <div class="sv-archive__map" data-map="bounds" data-lat="56.46" data-lng="-2.97" data-zoom="13">
                    <?php foreach ($markers as $index => $marker) {
                        $num = $index + 1;
                        ?>
                        <div
                            data-marker
                            data-lat="<?= $marker['lat']; ?>"
                            data-lng="<?= $marker['lng']; ?>"
                            data-label="<?= $num; ?>"
                            data-focus="job-<?= $num; ?>"
                        ></div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="sv-archive__contentWrap flow">
            <h1 class="fs-2">Volunteering</h1>

            <div class="fs-3 ff-title fw-medium text-theme">Search for volunteering opportunities</div>

            <div class="fw-medium text-dark-pale">
                <?php printf(
                    '%s volunteering %s - Showing page %s of %s',
                    $total_items,
                    $total_items === 1 ? 'opportunity' : 'opportunities',
                    $curr_page,
                    $total_pages
                ); ?>
            </div>

            <ul class="sv-archive__list flow" role="list">
                <?php Blue2\Common\Theme\Utils::archiveLoop(); ?>
            </ul>

            <?php the_posts_pagination([
                'class'     => 'sv-archive__pagination',
                'prev_text' => '&lt; Prev',
                'next_text' => 'Next &gt;'
            ]); ?>
        </div>

    </section>

    <?php

    get_template_part('templates/parts/link_block');

    get_template_part('templates/parts/newsletter');

    ?>
</main>
