(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["google-maps"],{

/***/ "./assets/scripts/google-maps/index.js":
/*!*********************************************!*\
  !*** ./assets/scripts/google-maps/index.js ***!
  \*********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* global google */

/**
 * googleMap
 *
 * Finds any google maps on page and initialises them using data attributes and children.
 *
 * Map Options:
 *  - data-map: Sets mode of map, changing behaviour
 *      - default:  Will center map on 'lat' and 'lng' options regardless of markers
 *      - bounds:   After markers added the map will be positioned and zoomed to fit markers.
 *                  'zoom' option with 'bounds' defines the maximum zoom level.
 *  - data-lat: Defines latitude of map center. In 'bounds' mode just defines initial center.
 *  - data-lng: Defines longitude of map center. In 'bounds' mode just defines initial center.
 *  - data-zoom: In 'default' mode sets zoom level. In 'bounds' mode sets maximum zoom level.
 *
 * eg: <div data-map="bounds" data-lat="56.46" data-lng="-2.97" data-zoom="13"></div>
 *
 * Markers are defined by child elements to the map with data-marker attribute.
 * Marker Options:
 *  - data-lat:     Latitude of map marker.
 *  - data-lng:     Longitude of map marker.
 *  - data-label:   Label displayed on map pin. A single character is recommended.
 *  - data-focus:   If this marker is clicked, focus and scroll to the element with this ID.
 */
var googleMap = function googleMap() {
  var maps = document.querySelectorAll('[data-map]'); // Check if scrollIntoViewIfNeeded is supported so we can use that instead of scrollIntoView

  var supportsScrollIntoViewIfNeeded = Boolean(document.documentElement.scrollIntoViewIfNeeded); // Loop through all maps initialising

  maps.forEach(function (mapEl) {
    // Parse options from map element
    var lat = parseFloat(mapEl.getAttribute('data-lat'));
    var lng = parseFloat(mapEl.getAttribute('data-lng'));
    var zoom = parseFloat(mapEl.getAttribute('data-zoom'));
    var useBounds = mapEl.getAttribute('data-map') === 'bounds'; // Loop markers within current mapEl, adding all data attributes to array.
    // Needs to be done before map init as that destroys the marker elements.

    var markers = [];
    mapEl.querySelectorAll('[data-marker]').forEach(function (markerEl) {
      markers.push(markerEl.dataset);
    }); // Initialise map

    var map = new google.maps.Map(mapEl, {
      zoom: zoom,
      center: new google.maps.LatLng(lat, lng),
      mapTypeId: google.maps.MapTypeId.ROADMAP
    }); // If 'bounds' mode set, create Bounds object to add markers to.

    var bounds;

    if (useBounds) {
      bounds = new google.maps.LatLngBounds();
    } // Loop through marker array, adding them as markers to the map


    markers.forEach(function (data) {
      // Parse options for lat/lng, set map to be added to, and define our custom icon
      var options = {
        position: new google.maps.LatLng(parseFloat(data.lat), parseFloat(data.lng)),
        map: map,
        icon: {
          // We are using font-awesome map-marker solid svg here, inline for convenience.
          // This has to be encoded for use as a data:image.
          url: 'data:image/svg+xml;utf-8,%3Csvg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512" height="32" width="24"%3E%3Cpath fill="%237B2C87" d="M172 502C27 291 0 269 0 192a192 192 0 11384 0c0 77-27 99-172 310a24 24 0 01-40 0z"/%3E%3C/svg%3E',
          // Anchor is center/bottom
          anchor: new google.maps.Point(12, 32),
          // Set center point for label, here chosen as slightly above center
          labelOrigin: new google.maps.Point(12, 14)
        }
      }; // If label is defined, add it to options object

      if (data.label) {
        options.label = {
          text: data.label,
          color: '#fff'
        };
      } // Define and add marker


      var marker = new google.maps.Marker(options); // If 'bounds' mode set, extend the bounds to include the position of this marker.

      if (useBounds) {
        bounds.extend(marker.getPosition());
      } // If 'data-focus' option set, add event listener for click. On click, if the value is
      // a valid ID, focus it and if scrollIntoViewIfNeeded supported scroll if outside viewport.
      // If scrollIntoViewIfNeeded not supported, use scrollIntoView.


      if (data.focus) {
        marker.addListener('click', function () {
          var focusEl = document.getElementById(data.focus);

          if (focusEl) {
            focusEl.focus();

            if (supportsScrollIntoViewIfNeeded) {
              focusEl.scrollIntoViewIfNeeded();
            } else {
              focusEl.scrollIntoView();
            }
          }
        });
      }
    }); // If 'bounds' mode set, reposition and zoom the map to include all markers.
    // As fitBounds is async, listen for change and then adjust the zoom to add some
    // padding and to ensure zoom is not above set maximum.

    if (useBounds) {
      google.maps.event.addListenerOnce(map, 'bounds_changed', function () {
        var currZoom = this.getZoom();
        var newZoom = Math.min(currZoom - 1, zoom);
        this.setZoom(newZoom);
      });
      map.fitBounds(bounds);
    }
  });
};
/**
 * awaitLoaded
 *
 * if google maps api already loaded then init immediately, else
 * add an event listener to wait for load
 */


var awaitLoaded = function awaitLoaded() {
  if (typeof google.maps !== 'undefined') {
    googleMap();
  } else {
    document.documentElement.addEventListener('googleMapsLoad', googleMap, {
      once: true
    });
  }
};

/* harmony default export */ __webpack_exports__["default"] = (awaitLoaded);

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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