<?php
/**
 * Content Template for Voluntary Job CPT
 *
 * @todo add decorative SVGs
 * @todo add google map
 *
 * @package DVVA_Theme
 */

$company = get_field('company');
$description = get_field('description');
$aims = get_field('aims');
$availability = get_field('availability');
$restrictions = get_field('restrictions');
$support = get_field('support');
$contact = get_field('contact');
$location = get_field('location');

$apply_button = '<a class="sv-single__btn b-button" href="%s"%s>Apply</a>';
if ($contact['method'] === 'email' && $contact['email']) {
    $apply_button = sprintf(
        $apply_button,
        'mailto:' . sanitize_email($contact['email']),
        ''
    );

} elseif ($contact['method'] === 'link' && $contact['link']) {
    $apply_button = sprintf(
        $apply_button,
        esc_url($contact['link']),
        ' rel="noopener"'
    );

} else {
    $apply_button = false;
}

$themes = Blue2\Scruffy\Utils::term_list('theme');

?>

<main class="l-main">
    <section class="sv-single fs-7">
        <div class="contain">
            <div class="row justify-content-between">

                <div class="col-12 col-lg-6">

                    <div class="sv-single__section sv-single__section--head">
                        <a class="text-theme text-decoration-none fw-medium d-inline-block mb-4" href="/volunteer/">Go back to all listings</a>

                        <div class="row justify-content-between">
                            <div class="sv-single__info fw-medium">
                                <h1 class="sv-single__title text-theme"><?= Blue2\Common\Theme\Utils::getTitle(); ?></h1>

                                <?php if ($company) { ?>
                                    <p class="text-primary"><?= $company; ?></p>
                                <?php } ?>

                                <p class="text-dark-pale"><?= $themes; ?></p>
                            </div>

                            <?php if ($apply_button) { ?>
                                <div class="sv-single__infoBtn">
                                    <?= $apply_button; ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>

                    <?php if ($description) { ?>
                        <div class="sv-single__section flow">
                            <h2>Description</h2>
                            <?= $description; ?>
                        </div>
                    <?php } ?>

                    <?php if ($aims) { ?>
                        <div class="sv-single__section flow">
                            <h2>Organisation aims and objectives</h2>
                            <?= $aims; ?>
                        </div>
                    <?php } ?>

                    <?php if ($availability['table'] || $availability['content']) { ?>
                        <div class="sv-single__section flow">
                            <h2>Availability</h2>

                            <?php if ($availability['table']) {
                                $cols = [
                                    'mon' => 'Mon',
                                    'tue' => 'Tue',
                                    'wed' => 'Wed',
                                    'thu' => 'Thu',
                                    'fri' => 'Fri',
                                    'sat' => 'Sat',
                                    'sun' => 'Sun'
                                ];
                                ?>
                                <div class="sv-single__availWrap" tabindex="0">
                                    <table class="sv-single__availability text-center">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <?php foreach ($cols as $key => $title) { ?>
                                                    <th><?= $title; ?></th>
                                                <?php } ?>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($availability['table'] as $row) { ?>
                                                <tr>
                                                    <th><?= $row['title'] ?></th>
                                                    <?php foreach ($cols as $key => $title) {
                                                        if ($row[$key]) {
                                                            echo '<td class="fas fa-check-square text-theme" aria-label="Yes"></td>';
                                                        } else {
                                                            echo '<td aria-label="No"></td>';
                                                        }
                                                    } ?>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } ?>

                            <?= $availability['content']; ?>
                        </div>
                    <?php } ?>

                    <?php if ($restrictions['experience'] || $restrictions['age_min']) { ?>
                        <div class="sv-single__section flow">
                            <h2>Restrictions</h2>

                            <?= $restrictions['general']; ?>

                            <?php if ($restrictions['experience']) { ?>
                                <p>
                                    <strong class="text-theme">Experience required:</strong> <?= $restrictions['experience']; ?>
                                </p>
                            <?php } ?>

                            <?php if ($restrictions['travel']) { ?>
                                <p>
                                    <strong class="text-theme">Travel details:</strong> <?= $restrictions['travel']; ?>
                                </p>
                            <?php } ?>

                            <?php if ($restrictions['age_min']) { ?>
                                <p>
                                    <strong class="text-theme">Minimum age:</strong> <?= $restrictions['age_min']; ?>
                                </p>
                            <?php } ?>
                        </div>
                    <?php } ?>

                    <?php if ($support['taster'] || $support['training_details'] || $support['support']) { ?>
                        <div class="sv-single__section flow">
                            <h2>Support</h2>

                            <p>
                                <strong class="text-theme">Taster available:</strong>
                                <?= $support['taster'] ? 'Yes' : 'No'; ?>
                            </p>

                            <?php if ($support['taster_details']) { ?>
                                <p>
                                    <strong class="text-theme">Taster details:</strong> <?= $support['taster_details']; ?>
                                </p>
                            <?php } ?>

                            <?php if ($support['training_details']) { ?>
                                <p>
                                    <strong class="text-theme">Training details:</strong> <?= $support['training_details']; ?>
                                </p>
                            <?php } ?>

                            <?php if ($support['support']) { ?>
                                <p>
                                    <strong class="text-theme">Support:</strong> <?= $support['support']; ?>
                                </p>
                            <?php } ?>
                        </div>
                    <?php } ?>

                    <div class="sv-single__section sv-single__section--foot flow">
                        <?php if ($contact['name']) { ?>
                            <p>
                                <strong class="text-theme">Contact name:</strong> <?= $contact['name']; ?>
                            </p>
                        <?php } ?>

                        <?= $apply_button; ?>
                    </div>

                </div>

                <div class="col-12 col-lg-5 pt-4 flow">
                    <img src="https://via.placeholder.com/663x640?text=map" width="663" height="640" alt="">

                    <div>
                        <?= $company; ?>
                        <?php if ($location['postcode']) { ?>
                            <div>
                                Postcode: <?= $location['postcode']; ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <?php

    get_template_part('templates/parts/link_block');

    get_template_part('templates/parts/newsletter');

    ?>
</main>
