<?php
/**
 * Archive Item Template for Voluntary Job CPT
 *
 * @package DVVA_Theme
 */

$title = get_the_title();
$permalink = get_the_permalink();
$company = get_field('company');

$truncate_excerpt = false;
$excerpt = get_field('excerpt');
if (!$excerpt) {
    $truncate_excerpt = true;
    $excerpt = wp_strip_all_tags(get_field('description'));
}

$themes = Blue2\Scruffy\Utils::term_list('theme');

?>

<li>
    <article class="sv-archive__item bg-white flex-column flow">
        <h2 class="sv-archive__title ff-main fw-medium fs-3">
            <a class="sv-archive__link text-decoration-none text-theme" href="<?= $permalink; ?>">
                <?= $title; ?>
            </a>
        </h2>
        <?php if ($company) { ?>
            <p class="fw-medium text-theme"><?= $company; ?></p>
        <?php } ?>
        <p class="fw-medium text-dark-pale"><?= $themes; ?></p>
        <p class="sv-archive__excerpt<?= $truncate_excerpt ? ' sv-archive__excerpt--truncate' : ''; ?>"><?= $excerpt; ?></p>
        <span class="b-button mt-5 ms-auto" aria-hidden="true">Learn More</span>
    </article>
</li>
