<?php
/**
 * Archive Template for Voluntary Job CPT
 *
 * @todo add google map
 * @todo add search/filtering
 *
 * @package DVVA_Theme
 */

global $wp_query;
$total_items = $wp_query->found_posts;
$curr_page = get_query_var('paged') ?: 1;
$total_pages = $wp_query->max_num_pages;

?>

<main class="l-main">
    <section class="sv-archive bg-light fs-7" data-full>

        <div class="sv-archive__mapWrap" aria-hidden="true">
            <div class="sv-archive__map"></div>
        </div>

        <div class="sv-archive__contentWrap flow">
            <h1 class="fs-2">Volunteering</h1>

            <div class="fs-3 ff-title fw-medium text-theme">Search for volunteering opportunities</div>

            <div class="fw-medium text-dark-pale">
                <?php printf(
                    '%s volunteering %s - Showing page %s of %s',
                    $total_items,
                    $total_items === 1 ? 'opportunity' : 'opportunities',
                    $curr_page,
                    $total_pages
                ); ?>
            </div>

            <ul class="sv-archive__list flow" role="list">
                <?php Blue2\Common\Theme\Utils::archiveLoop(); ?>
            </ul>

            <?php the_posts_pagination([
                'class'     => 'sv-archive__pagination',
                'prev_text' => '&lt; Prev',
                'next_text' => 'Next &gt;'
            ]); ?>
        </div>

    </section>

    <?php

    get_template_part('templates/parts/link_block');

    get_template_part('templates/parts/newsletter');

    ?>
</main>
