<?php
/**
 * Latest News Section
 *
 * Flexible content section for 'latest_news' section.
 *
 * @package DVVA_Theme
 */

$title = get_sub_field('title');
$link = get_sub_field('link');

// temporary until dynamic feed added
$news = [
    [
        'type'        => 'Voluntary Sector Jobs',
        'title'       => 'Recruitment: Helm',
        'description' => '
            <p>Helm are recruiting for an Employment Liaison Officer and an Instructor/ Assessor</p>
            <p>Employment Liaison Officer</p>
        '
    ],
    [
        'type'        => 'Voluntary Sector Jobs',
        'title'       => 'Recruitment: Social Isolation Project Workers',
        'description' => '
            <p>One full time, fixed term post and one part time, permanent post for great communicators in DVVA&apos;s Social Isolation Team</p>
        '
    ],
    [
        'type'        => 'News',
        'title'       => 'Lindsays Employment Advice',
        'description' => '
            <p>Furlough factor adds new dimension to ensuring fair play with third sector redundancies.</p>
            <p>When it comes to issues surrounding potential redundancies, it&apos;s not just morally right for us to ensure that everyone is treated fairly &ndash; it&apos;s a legal necessity.</p>
        '
    ],
    [
        'type'        => 'Voluntary Sector Jobs',
        'title'       => 'Recruitment: DEAP',
        'description' => '
            <p>Experienced Employability Officer x 2- DEAP Limited</p>
            <p>For immediate start</p>
            <p>Salary: £22809 to £24612 depending on experience</p>
        '
    ]
];

?>

<section class="s-latestNews" data-full>
    <div class="contain">
        <div class="s-latestNews__head">
            <h2><?= $title; ?></h2>

            <?php if ($link && $link['url']) { ?>
                <a
                    href="<?= $link['url']; ?>"
                    class="text-primary fs-4 ms-3"
                    aria-label="See more news">
                    <span class="far fa-arrow-right"></span>
                </a>
            <?php } ?>
        </div>
    </div>

    <ul role="list" class="s-latestNews__scroll">
        <?php foreach ($news as $item) { ?>
            <li>
                <article class="s-latestNews__box flex-column flow">
                    <?php // remove type from accessibility tree as it sits before title ?>
                    <div aria-hidden="true"><?= $item['type']; ?></div>

                    <h3>
                        <a href="#0" class="s-latestNews__link text-decoration-none">
                            <?= $item['title']; ?>
                        </a>
                    </h3>

                    <?php // remove type visually as it already appears ?>
                    <div class="visually-hidden"><?= $item['type']; ?></div>

                    <div class="s-latestNews__desc mb-auto flow">
                        <?= $item['description']; ?>
                    </div>

                    <div class="s-latestNews__arrow fal fa-long-arrow-right"></div>
                </article>
            </li>
        <?php } ?>
    </ul>
</section>
