<?php
/**
 * Content Section
 *
 * Flexible content section for 'content' section.
 *
 * @package DVVA_Theme
 */

$id = get_sub_field('id');
$content = get_sub_field('content');
$sidebar = get_sub_field('sidebar');

?>

<section
    <?= $id ? 'id="' . $id . '"' : '' ?>
    class="s-content lh-sm">
    <div class="contain">
        <div class="s-content__main">
            <div class="row justify-content-between">
                <div class="col-12 col-md-7 flow">
                    <?= $content; ?>
                </div>

                <?php if ($sidebar) { ?>
                    <div class="col-12 col-md-4">
                        <?php switch ($sidebar) {
                            case 'image':
                                $image = get_sub_field('image');
                                printf('<img
                                    src="%s"
                                    class="s-content__img"
                                    alt="%s"
                                    width="%s"
                                    height="%s"
                                    loading="lazy">',
                                    $image['url'],
                                    $image['alt'],
                                    $image['width'],
                                    $image['height']
                                );
                                break;

                            case 'html':
                                the_sub_field('html');
                                break;
                        } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
