<?php
/**
 * Site Footer
 *
 * Includes footer navigation, colophon
 *
 * @package DVVA_Theme
 */

?>

<footer class="l-footer bg-light">
    <div class="contain">

        <?php // explicitly landmark footer for screenreaders ?>
        <h2 class="visually-hidden">Footer and company info</h2>

        <div class="row">

            <?php
            $icon = get_field('company_icon', 'options');
            if ($icon) { ?>
                <div class="l-footer__iconWrap col-12 col-md-auto pb-2">
                    <img
                        class="l-footer__icon"
                        src="<?= $icon['url']; ?>"
                        alt="<?= $icon['alt']; ?>"
                        loading="lazy"
                        width="<?= $icon['width']; ?>"
                        height="<?= $icon['height']; ?>" />
                </div>
            <?php } ?>

            <div class="col">
                <div class="l-footer__wrap">
                    <div class="l-footer__content flow lh-sm">
                        <h3 class="visually-hidden">Company Information</h3>
                        <?php the_field('footer_company_info', 'options'); ?>
                        <p>
                            &copy; <?= date('Y'); ?> <?php bloginfo('name'); ?>.
                        </p>
                    </div>

                    <?php if (has_nav_menu('secondary')) { ?>
                        <h3 class="visually-hidden">Footer Navigation</h3>
                        <nav class="l-footer__nav ff-title text-primary">
                            <?php wp_nav_menu([
                                'theme_location'    => 'secondary',
                                'menu_container'    => 'ul',
                                'menu_class'        => 'l-footer__menu flow',
                                'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                            ]); ?>
                        </nav>
                    <?php } ?>

                    <div class="l-footer__social">
                        <h3>Follow us</h3>
                        <?php
                        $social_media = get_field('social_media_channels', 'options');
                        if ($social_media) { ?>
                            <ul class="l-footer__socialList" role="list">
                                <?php foreach ($social_media as $social) { ?>
                                    <li class="d-inline-block">
                                        <a class="l-footer__socialBtn" href="<?= $social['url']; ?>" aria-label="DVVA <?= $social['network']['label']; ?> page">
                                            <span class="fab fa-<?= $social['network']['value']; ?>"></span>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>

                    <nav class="l-footer__colophon">
                        <?php wp_nav_menu([
                            'theme_location'    => 'tertiary',
                            'menu_container'    => 'ul',
                            'menu_class'        => 'l-footer__coloMenu',
                            'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                        ]); ?>
                        <span class="l-footer__credit">Website by <?= do_shortcode('[blue2_logo type="dark"]'); ?></span>
                    </nav>
                </div>

            </div>

        </div>

        <div class="l-footer__logos mt-5 text-center">
            <h2 class="visually-hidden">Our Partners</h2>
            <?php
            $partners = get_field('footer_partners', 'options');
            if ($partners) { ?>
                <ul class="l-footer__logoList" role="list">
                    <?php foreach ($partners as $partner) { ?>
                        <li>
                            <img
                                src="<?= $partner['url']; ?>"
                                alt="<?= $partner['alt']; ?>"
                                loading="lazy"
                                width="<?= $partner['width']; ?>"
                                height="<?= $partner['height']; ?>">
                        </li>
                    <?php } ?>
                </ul>
            <?php } ?>
        </div>

    </div>
</footer>
