<?php
/**
 * Blog archive template
 *
 * @package DVVA_Theme
 */

$blog_page = get_option('page_for_posts');
$current_cat = false;

$title = get_the_title($blog_page);
if (is_category()) {
    $current_cat = get_queried_object();
    $title .= ': ' . $current_cat->name;
    $current_cat = $current_cat->slug;
}

?>

<main class="l-main bg-primary-pale">
    <?php get_template_part('templates/parts/titlebar', null, [
        'title' => $title
    ]); ?>

    <?php $categories = get_categories([
        'orderby'       => 'name',
        'order'         => 'ASC'
    ]); ?>
    <section class="s-subnav ff-title text-theme fw-bold overflow-hidden text-center text-uppercase" data-dotted>
        <nav class="contain" aria-label="Post categories">
            <div class="s-subnav__main">
                <ul class="s-subnav__list" role="list">
                    <li>
                        <a
                            class="s-subnav__link text-decoration-none"
                            href="<?= get_the_permalink($blog_page); ?>"
                            <?= !$current_cat ? 'aria-current="page"' : null; ?>>
                            All Posts
                        </a>
                    </li>
                    <?php foreach ($categories as $category) { ?>
                        <li>
                            <a
                            class="s-subnav__link text-decoration-none"
                            href="<?= get_category_link($category->term_id); ?>"
                            <?= $current_cat === $category->slug ? 'aria-current="page"' : null; ?>>
                                <?= esc_html($category->name); ?>
                            </a>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </nav>
    </section>

    <div class="sp-archive">
        <div class="contain">
            <div class="row">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>

                <?php the_posts_pagination([
                    'class'     => 'b-pagination',
                    'prev_text' => '&lt; Prev',
                    'next_text' => 'Next &gt;'
                ]); ?>
            </div>
        </div>
    </div>

    <?php get_template_part('templates/parts/newsletter'); ?>
</main>
