<?php

namespace Blue2\Scruffy\Controllers;

class WooCommerceController
{
    public function __construct()
    {
        $this->registerFilters();
        $this->registerActions();
    }

    public function registerFilters()
    {
        add_filter( 'woocommerce_bookings_calculated_booking_cost', [$this, 'customBookingModification'], 10, 3 );
        add_filter('woocommerce_process_registration_errors', [$this, 'validateRegistrationFields'], 20, 4);

    }

    public function registerActions() {
        add_action( 'init', [$this, 'removeWooBreadcrumbs']);
        add_action('woocommerce_before_calculate_totals', [$this, 'recalculateTotals'], 10, 1);


        add_action( 'woocommerce_register_form', [$this, 'customRegisterFields'] );
        add_action( 'woocommerce_created_customer', [$this, 'saveCustomRegisterFields'] );
        add_action('show_user_profile', [$this, 'addRegistrationFieldsToAdmin'], 30); // admin: edit profile
        add_action('edit_user_profile', [$this, 'addRegistrationFieldsToAdmin'], 30); // admin: edit other users

        add_action( 'user_register', [$this, 'registrationRedirect', 10, 1]);
    }

    function removeWooBreadcrumbs() {
        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
        remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
        remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
        remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
        remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
    }

    public static function getMembership() {
        $user = get_current_user_id();
        $membership = wc_memberships_get_user_active_memberships($user);
        $membership = $membership[0]->plan->slug;
        return $membership;
    }

    public static function customBookingModification( $booking_cost, $product, $data ) {
        $membership = self::getMembership();
        $duration = $data['_duration'];
        if($membership == 'dvva-membership'){
            $user = get_current_user_id();
            $membership = \wc_memberships_get_user_active_memberships($user);
            $discount = \wc_memberships_get_member_product_discount($membership[0], $product->get_id());
            $booking_cost = $booking_cost - ($discount * $duration);
        }
        return $booking_cost;
    }

    public function recalculateTotals($cart){
        do_action( 'wc_memberships_discounts_disable_price_adjustments' );
    }

    public function getCustomRegisterFields()
    {
        return apply_filters('custom_register_fields', [
            'phone' => [
                'type'        => 'text',
                'required'    => true,
                'custom_attributes' => ['required' => 'required'],
                'label'       => 'Phone',
            ],
            'contact_name' => [
                'type'        => 'text',
                'required'    => true,
                'custom_attributes' => ['required' => 'required'],
                'label'       => 'Contact Name'
            ],
            'company' => [
                'type'        => 'text',
                'required'    => false,
                'label'       => 'Company/Organisation'
            ],
            'website' => [
                'type'        => 'text',
                'required'    => false,
                'label'       => 'Organisation Website'
            ],
            'organisation_role' => [
                'type'        => 'text',
                'required'    => false,
                'label'       => 'Role in Organisation'
            ],
            'address' => [
                'type'        => 'textarea',
                'required'    => true,
                'label'       => 'Address',
                'custom_attributes' => ['required' => 'required'],
                'description' => 'Please enter full address with postcode'
            ],
            'consent_1' => [
                'type'        => 'checkbox',
                'custom_attributes' => ['required' => 'required'],
                'required'    => true,
                'label'       => 'I consent to Dundee Volunteer and Voluntary Action processing my/our details for inclusion on DVVA’s membership database',
            ],
            'consent_2' => [
                'type'        => 'checkbox',
                'required'    => false,
                'label'       => 'I consent to our name and website details being included on DVVA’s website',
            ],
            'consent_4' => [
                'type'        => 'checkbox',
                'required'    => false,
                'label'       => 'I consent to my/our details being added to the DVVA Mailing List',
            ],
        ]);
    }


    public function customRegisterFields()
    {
        $fields = $this->getCustomRegisterFields();
        foreach ($fields as $key => $field_args) {
            $sanitize = isset($field_args['sanitize']) ? $field_args['sanitize'] : 'wc_clean';
            $value = isset($_POST[$key]) ? call_user_func($sanitize, $_POST[$key]) : '';
            woocommerce_form_field($key, $field_args, $value);
        }
    }

    public function saveCustomRegisterFields($customer_id)
    {

        $fields = $this->getCustomRegisterFields();
        foreach ($fields as $key => $field_args) {
            $sanitize = isset($field_args['sanitize']) ? $field_args['sanitize'] : 'wc_clean';
            $value = isset($_POST[$key]) ? call_user_func($sanitize, $_POST[$key]) : '';
            update_user_meta($customer_id, $key, $value);
        }
    }

    public function validateRegistrationFields($validation_error, $username, $password, $email)
    {
        $fields = $this->getCustomRegisterFields();

        foreach ($fields as $key => $field_args) {
            if (isset($field_args['required']) && $field_args['required']) {
                $sanitize = isset($field_args['sanitize']) ? $field_args['sanitize'] : 'wc_clean';
                $value = isset($_POST[$key]) ? call_user_func($sanitize, $_POST[$key]) : '';

                if (!$value || $value == '') {
                    $validation_error->add('', 'Missing Required field: '.$field_args['label']);
                }
            }
        }
        return $validation_error;
    }

    public function addRegistrationFieldsToAdmin()
    {
        $fields = $this->getCustomRegisterFields();
        $user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : get_current_user_id(); ?>
        <h2><?php _e('Additional Information', 'dvva'); ?></h2>
        <table class="form-table" id="iconic-additional-information">
            <tbody>
            <?php foreach ($fields as $key => $field_args) {
                $value = get_user_meta($user_id, $key, true); ?>
                <tr>
                    <th>
                        <label for="<?php echo $key; ?>"><?php echo $field_args['label']; ?></label>
                    </th>
                    <td>
                        <?php $field_args['label'] = false; ?>
                        <?php woocommerce_form_field($key, $field_args, $value); ?>
                    </td>
                </tr>
                <?php
            } ?>
            </tbody>
        </table>
        <?php
    }

    public function registrationRedirect() {
        if(is_page('become-a-member')) {
            wp_safe_redirect('/my-account');
        }
    }

}
