(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["google-maps"],{

/***/ "./assets/scripts/google-maps/index.js":
/*!*********************************************!*\
  !*** ./assets/scripts/google-maps/index.js ***!
  \*********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* global google */

/**
 * googleMap
 *
 * Finds any google maps on page and initialises them using data attributes and children.
 *
 * Map Options:
 *  - data-map: Sets mode of map, changing behaviour
 *      - default:  Will center map on 'lat' and 'lng' options regardless of markers
 *      - bounds:   After markers added the map will be positioned and zoomed to fit markers.
 *                  'zoom' option with 'bounds' defines the maximum zoom level.
 *  - data-lat: Defines latitude of map center. In 'bounds' mode just defines initial center.
 *  - data-lng: Defines longitude of map center. In 'bounds' mode just defines initial center.
 *  - data-zoom: In 'default' mode sets zoom level. In 'bounds' mode sets maximum zoom level.
 *
 * eg: <div data-map="bounds" data-lat="56.46" data-lng="-2.97" data-zoom="13"></div>
 *
 * Markers are defined by child elements to the map with data-marker attribute.
 * Marker Options:
 *  - data-lat:     Latitude of map marker.
 *  - data-lng:     Longitude of map marker.
 *  - data-label:   Label displayed on map pin. A single character is recommended.
 *  - data-focus:   If this marker is clicked, focus and scroll to the element with this ID.
 */
var googleMap = function googleMap() {
  var maps = document.querySelectorAll('[data-map]'); // Check if scrollIntoViewIfNeeded is supported so we can use that instead of scrollIntoView

  var supportsScrollIntoViewIfNeeded = Boolean(document.documentElement.scrollIntoViewIfNeeded); // Loop through all maps initialising

  maps.forEach(function (mapEl) {
    // Parse options from map element
    var lat = parseFloat(mapEl.getAttribute('data-lat'));
    var lng = parseFloat(mapEl.getAttribute('data-lng'));
    var zoom = parseFloat(mapEl.getAttribute('data-zoom'));
    var useBounds = mapEl.getAttribute('data-map') === 'bounds'; // Loop markers within current mapEl, adding all data attributes to array.
    // Needs to be done before map init as that destroys the marker elements.

    var markers = [];
    mapEl.querySelectorAll('[data-marker]').forEach(function (markerEl) {
      markers.push(markerEl.dataset);
    }); // Initialise map

    var map = new google.maps.Map(mapEl, {
      zoom: zoom,
      center: new google.maps.LatLng(lat, lng),
      mapTypeId: google.maps.MapTypeId.ROADMAP
    }); // If 'bounds' mode set, create Bounds object to add markers to.

    var bounds;

    if (useBounds) {
      bounds = new google.maps.LatLngBounds();
    } // Loop through marker array, adding them as markers to the map


    markers.forEach(function (data) {
      // Parse options for lat/lng, set map to be added to, and define our custom icon
      var options = {
        position: new google.maps.LatLng(parseFloat(data.lat), parseFloat(data.lng)),
        map: map,
        icon: {
          // We are using font-awesome map-marker solid svg here, inline for convenience.
          // This has to be encoded for use as a data:image.
          url: 'data:image/svg+xml;utf-8,%3Csvg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512" height="32" width="24"%3E%3Cpath fill="%237B2C87" d="M172 502C27 291 0 269 0 192a192 192 0 11384 0c0 77-27 99-172 310a24 24 0 01-40 0z"/%3E%3C/svg%3E',
          // Anchor is center/bottom
          anchor: new google.maps.Point(12, 32),
          // Set center point for label, here chosen as slightly above center
          labelOrigin: new google.maps.Point(12, 14)
        }
      }; // If label is defined, add it to options object

      if (data.label) {
        options.label = {
          text: data.label,
          color: '#fff'
        };
      } // Define and add marker


      var marker = new google.maps.Marker(options); // If 'bounds' mode set, extend the bounds to include the position of this marker.

      if (useBounds) {
        bounds.extend(marker.getPosition());
      } // If 'data-focus' option set, add event listener for click. On click, if the value is
      // a valid ID, focus it and if scrollIntoViewIfNeeded supported scroll if outside viewport.
      // If scrollIntoViewIfNeeded not supported, use scrollIntoView.


      if (data.focus) {
        marker.addListener('click', function () {
          var focusEl = document.getElementById(data.focus);

          if (focusEl) {
            focusEl.focus();

            if (supportsScrollIntoViewIfNeeded) {
              focusEl.scrollIntoViewIfNeeded();
            } else {
              focusEl.scrollIntoView();
            }
          }
        });
      }
    }); // If 'bounds' mode set, reposition and zoom the map to include all markers.
    // As fitBounds is async, listen for change and then adjust the zoom to add some
    // padding and to ensure zoom is not above set maximum.

    if (useBounds) {
      google.maps.event.addListenerOnce(map, 'bounds_changed', function () {
        var currZoom = this.getZoom();
        var newZoom = Math.min(currZoom - 1, zoom);
        this.setZoom(newZoom);
      });
      map.fitBounds(bounds);
    }
  });
};
/**
 * awaitLoaded
 *
 * if google maps api already loaded then init immediately, else
 * add an event listener to wait for load
 */


var awaitLoaded = function awaitLoaded() {
  if (typeof google.maps !== 'undefined') {
    googleMap();
  } else {
    document.documentElement.addEventListener('googleMapsLoad', googleMap, {
      once: true
    });
  }
};

/* harmony default export */ __webpack_exports__["default"] = (awaitLoaded);

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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