<?php
/**
 * Archive Template for Voluntary Job CPT
 *
 * For Map options:
 * @see /assets/scripts/google-maps/index.js
 *
 * @package DVVA_Theme
 */

// Get number of total items, number of items on this page, and page number.
global $wp_query;
$total_items = $wp_query->found_posts;
$curr_page = get_query_var('paged') ?: 1;
$total_pages = $wp_query->max_num_pages;

// Run the post loop so we can get location for each item for use in map.
$markers = [];
if (have_posts()) {
    while (have_posts()) {
        the_post();
        $location = get_field('location');
        if ($location['lat'] && $location['lng']) {
            $markers[$wp_query->current_post] = [
                'lat' => $location['lat'],
                'lng' => $location['lng']
            ];
        }
    }
}

// reset post loop for re-use in item list
rewind_posts();

?>

<main class="l-main">
    <section class="sv-archive bg-light fs-7" data-full>

        <div class="sv-archive__mapCol" aria-hidden="true">
            <div class="sv-archive__mapWrap">
                <div class="sv-archive__map" data-map="bounds" data-lat="56.46" data-lng="-2.97" data-zoom="13">
                    <?php foreach ($markers as $index => $marker) {
                        $num = $index + 1;
                        ?>
                        <div
                            data-marker
                            data-lat="<?= $marker['lat']; ?>"
                            data-lng="<?= $marker['lng']; ?>"
                            data-label="<?= $num; ?>"
                            data-focus="job-<?= $num; ?>"
                        ></div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="sv-archive__contentWrap flow">
            <h1 class="fs-2">Volunteering</h1>

            <div class="fs-3 ff-title fw-medium text-theme">Search for volunteering opportunities</div>

            <form class="sv-archive__form row g-3 text-primary" action="<?= esc_url(home_url('/volunteer/')); ?>" method="get">
                <?php
                $filters = [
                    [
                        'args'  => Blue2\Scruffy\Taxonomy\Age::ARGS,
                        'label' => 'For volunteers aged'
                    ],
                    Blue2\Scruffy\Taxonomy\Service::ARGS,
                    Blue2\Scruffy\Taxonomy\SpecialistRole::ARGS,
                    Blue2\Scruffy\Taxonomy\Theme::ARGS
                ];
                foreach ($filters as $tax) {
                    // if args is set then write label and tax appropriately
                    $label = false;
                    if (($tax['args'] ?? false)) {
                        $label = $tax['label'];
                        $tax = $tax['args'];
                    }

                    // get terms to ensure they exist
                    $terms = get_terms([
                        'taxonomy'  => $tax['slug']
                    ]);

                    if ($terms) { ?>
                        <div class="col-auto">
                            <label for="filter-<?= $tax['slug']; ?>">
                                <?= $label ?: $tax['label_plural']; ?>:
                            </label>
                            <?php
                            $selected = ($_GET[$tax['slug']] ?? false) ? $_GET[$tax['slug']] : 0;
                            $select = wp_dropdown_categories([
                                'taxonomy'          => $tax['slug'],
                                'name'              => $tax['slug'],
                                'value_field'       => 'slug',
                                'selected'          => $selected,
                                'show_option_all'   => 'All ' . $tax['label_plural'],
                                'orderby'           => 'name',
                                'echo'              => 0,
                                'class'             => 'sv-archive__filter form-select text-primary',
                                'id'                => 'filter-' . $tax['slug']
                            ]);
                            $replace = '<select$1 onchange="return this.form.submit()">';
                            $select = preg_replace( '#<select([^>]*)>#', $replace, $select );
                            echo $select;
                            ?>
                        </div>
                        <?php
                    }
                } ?>

                <noscript>
                    <div class="col-auto">
                        <input class="b-button" type="submit" value="View" />
                    </div>
                </noscript>
            </form>

            <div class="fw-medium text-dark-pale">
                <?php printf(
                    '%s volunteering %s - Showing page %s of %s',
                    $total_items,
                    $total_items === 1 ? 'opportunity' : 'opportunities',
                    $curr_page,
                    $total_pages
                ); ?>
            </div>

            <ul class="sv-archive__list flow" role="list">
                <?php Blue2\Common\Theme\Utils::archiveLoop(); ?>
            </ul>

            <?php the_posts_pagination([
                'class'     => 'b-pagination',
                'prev_text' => '&lt; Prev',
                'next_text' => 'Next &gt;'
            ]); ?>
        </div>

    </section>

    <?php

    get_template_part('templates/parts/link_block');

    get_template_part('templates/parts/newsletter');

    ?>
</main>
