<?php
/**
 * Split Content Section
 *
 * Flexible content section for 'split_content' section.
 *
 * @package DVVA_Theme
 */

$title = get_sub_field('title');
$link = get_sub_field('link');
$direction = get_sub_field('direction');
$content = get_sub_field('content');
$image = get_sub_field('image');

?>

<section class="s-splitContent s-splitContent--<?= $direction; ?> flex-column" data-full>
    <div class="contain">
        <div class="s-splitContent__row row">
            <div class="col-12 col-lg-6">
                <div class="s-splitContent__content flex-column pt-4 pb-5 flow">
                    <h2 class="fs-1"><?= $title; ?></h2>

                    <?= $content; ?>

                    <?php if ($link && $link['url']) { ?>
                        <a href="<?= $link['url']; ?>" class="b-button" data-style="fill">
                            <span class="b-button__text"><?= $link['title'] ?: 'Learn more'; ?></span>
                            <span class="b-button__icon fal fa-long-arrow-right"></span>
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <?php if ($image) { ?>
        <?= \Blue2\Scruffy\Utils::acf_img($image, [
            'class' => 's-splitContent__img'
        ]); ?>
    <?php } ?>
</section>
