<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );
?>
    <main class="l-main">

        <?php get_template_part('templates/parts/titlebar', null, [
            'title' => 'Book',
            'description' => get_field('shop_archive_description', 'option')
        ]); ?>



        <div class="contain">

            <div class="woocommerce-notices-shortcode woocommerce">
                <?php wc_print_notices(); ?>
            </div>

            <?php
            $membershipTerm = get_term_by('slug', 'memberships', 'product_cat');
            $productCategories = get_terms('product_cat', ['exclude' => [$membershipTerm->term_id]]);
            $count = count($productCategories);
            if ( $count > 0 ) {
                foreach ($productCategories as $productCategory) {
                    $args = [
                        'posts_per_page' => -1,
                        'tax_query' => [
                            'relation' => 'AND',
                            [
                                'taxonomy' => 'product_cat',
                                'field' => 'slug',
                                'terms' => $productCategory->slug
                            ]
                        ],
                        'post_type' => 'product',
                        'orderby' => 'title,'
                    ];
                    $products = new WP_Query($args);

                    if($products->have_posts()) {
                        ?>
                        <div class="product-category-section">
                            <h2><?= $productCategory->name; ?></h2>

                            <div class="product-output">
                                <div class="row">
                                    <?php while ($products->have_posts()) {
                                        $products->the_post();
                                        $image = \Blue2\Scruffy\Site::getPostImage(get_the_id());
                                        $product = wc_get_product(get_the_id());
                                        $meta = get_post_meta(get_the_id()); ?>
                                        <div class="col-sm-6 col-md-4 col-xl-3 dvva-product-col">
                                            <?php if($productCategory->slug !== 'memberships') { ?><a href="<?php the_permalink(); ?>"><?php } ?>
                                                <div class="image-wrapper <?= $image['class']; ?>">
                                                    <?= $image['item']; ?>
                                                </div>
                                                <div class="content-wrapper">
                                                    <div class="title"><?php the_title(); ?></div>
                                                    <div class="price">
                                                        <?= get_woocommerce_currency_symbol() . number_format($product->get_price(), 2, '.', ''); ?>
                                                        <?php if (array_key_exists('_wc_booking_duration_unit', $meta)) { ?>
                                                            <span class="frequency">/ <?= $meta['_wc_booking_duration_unit'][0]; ?></span>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            <?php if($productCategory->slug !== 'memberships') { ?></a><?php } ?>

                                            <?php if($productCategory->slug == 'memberships') { ?>

                                                <?php if(get_the_content()) { ?>
                                                    <div class="description">
                                                        <?php the_content(); ?>
                                                    </div>
                                                <?php } ?>

                                                <a href="<?php
                                                $add_to_cart = do_shortcode('[add_to_cart_url id="'.$post->ID.'"]');
                                                echo $add_to_cart;
                                                ?>" class="buy-membership">Buy Membership</a>
                                            <?php } ?>

                                        </div>
                                        <?php
                                    }
                                    wp_reset_postdata(); ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
            } ?>
        </div>
    </main>
<?php
get_footer( 'shop' );
