<?php
/**
 * Head
 *
 * Open tags and <head> element
 * For anything visible, use site-header.php
 *
 * @package DVVA_Theme
 */

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-E78VH2TCHM"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'G-E78VH2TCHM');
    </script>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <?php wp_head(); ?>

    <?php
    /**
     * Fonts loaded locally but deferred with high priority
     */
    $font_url = get_template_directory_uri() . '/fonts/fonts.css';
    ?>
    <link rel="preload" as="style" href="<?= $font_url; ?>">
    <link rel="stylesheet" href="<?= $font_url; ?>" media="print" onload="this.media='all'" />
    <noscript><link rel="stylesheet" href="<?= $font_url ?>" /></noscript>

</head>
<body <?php body_class(); ?>>
