<main class="l-main">

    <?php get_template_part('templates/parts/titlebar', null, [
        'title' => get_the_title(),
        'description' => get_the_content()
    ]); ?>

    <div class="contain">

        <div class="woocommerce-notices-shortcode woocommerce">
            <?php wc_print_notices(); ?>
        </div>

        <div class="membership-output">
            <?php
            $args = [
                'posts_per_page' => -1,
                'tax_query' => [
                    'relation' => 'AND',
                    [
                        'taxonomy' => 'product_cat',
                        'field' => 'slug',
                        'terms' => 'memberships'
                    ]
                ],
                'post_type' => 'product',
                'orderby' => 'title,'
            ];
            $products = new WP_Query($args);

            if($products->have_posts()) {?>
                <div class="product-category-section">

                    <div class="product-output">
                        <div class="row">
                            <?php while ($products->have_posts()) {
                                $products->the_post();
                                $image = \Blue2\Scruffy\Site::getPostImage(get_the_id());
                                $product = wc_get_product(get_the_id());
                                $meta = get_post_meta(get_the_id()); ?>
                                <div class="col-sm-6 col-md-4 col-xl-3 dvva-product-col">

                                    <div class="image-wrapper <?= $image['class']; ?>">
                                        <?= $image['item']; ?>
                                    </div>
                                    <div class="content-wrapper">
                                        <div class="title"><?php the_title(); ?></div>
                                        <div class="price">
                                            <?= get_woocommerce_currency_symbol() . number_format($product->get_price(), 2, '.', ''); ?>
                                            <?php if (array_key_exists('_wc_booking_duration_unit', $meta)) { ?>
                                                <span class="frequency">/ <?= $meta['_wc_booking_duration_unit'][0]; ?></span>
                                            <?php } ?>
                                        </div>
                                    </div>


                                    <?php if(get_the_content()) { ?>
                                        <div class="description">
                                            <?php the_content(); ?>
                                        </div>
                                    <?php } ?>

                                    <a href="<?php
                                    $add_to_cart = do_shortcode('[add_to_cart_url id="'. get_the_id() .'"]');
                                    echo $add_to_cart;
                                    ?>" class="buy-membership">Buy Membership</a>
                                </div>
                                <?php
                            }
                            wp_reset_postdata(); ?>
                        </div>
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
    </div>


</main>

