<?php
/**
 * Intro Section
 *
 * Flexible content section for 'intro' section.
 *
 * @package DVVA_Theme
 */

$title = get_sub_field('title');
$content = get_sub_field('content');
$cards = get_sub_field('cards');

?>

<section class="s-intro">
    <div class="contain">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 text-center flow">
                <h2 class="s-intro__title"><?= $title; ?></h2>
                <?= $content; ?>
            </div>
        </div>

        <div class="row mt-0 text-white fw-light">
            <?php foreach ($cards as $card) { ?>
                <div class="col-12 col-md-6 col-lg-4">
                    <article class="s-intro__box flex-column bg-<?= $card['color']; ?> flow">
                        <h3 class="s-intro__boxTitle">
                            <?php
                            $pattern = '%s';
                            if ($card['link'] && $card['link']['url']) {
                                $pattern = '
                                    <a
                                        href="' . $card['link']['url'] . '"
                                        class="s-intro__boxLink text-white text-decoration-none fw-normal">
                                        %s
                                    </a>';
                            }
                            printf($pattern, $card['title']);
                            ?>
                        </h3>

                        <p class="mb-auto"><?= $card['content']; ?></p>

                        <?php if ($card['link'] && $card['link']['url']) { ?>
                            <div class="b-button ms-auto text-<?= $card['color']; ?>" data-style="expand" data-colour="inverse" aria-hidden="true">
                                <span class="b-button__text"><?= $card['link']['title'] ?? 'Read More'; ?></span>
                                <span class="b-button__icon fal fa-long-arrow-right"></span>
                            </div>
                        <?php } ?>
                    </article>
                </div>
            <?php } ?>
        </div>
    </div>
</section>
