<?php
/**
 * Latest News Section
 *
 * Flexible content section for 'latest_news' section.
 *
 * @package DVVA_Theme
 */

$title = get_sub_field('title');
$link = get_sub_field('link');

$the_query = new WP_Query([
    'numberposts' => 8
]);

?>

<section class="s-latestNews" data-full>
    <div class="contain">
        <div class="s-latestNews__head">
            <h2><?= $title; ?></h2>

            <?php if ($link && $link['url']) { ?>
                <a
                    href="<?= $link['url']; ?>"
                    class="text-primary fs-4 ms-3"
                    aria-label="See more news">
                    <span class="far fa-arrow-right"></span>
                </a>
            <?php } ?>
        </div>
    </div>

    <?php if ($the_query->have_posts()) { ?>
        <ul role="list" class="s-latestNews__scroll">
            <?php while ($the_query->have_posts()) {
                $the_query->the_post();
                $title = get_the_title();
                $link = get_the_permalink();
                $category = Blue2\Scruffy\Utils::get_primary_term();
                ?>
                <li>
                <article class="s-latestNews__post b-post flex-column flow">
                    <?php if ($category) {
                        // remove type from accessibility tree as it sits before title ?>
                        <div aria-hidden="true"><?= $category->name; ?></div>
                    <?php } ?>

                    <h3>
                        <a href="<?= $link; ?>" class="b-post__link text-decoration-none">
                            <?= $title; ?>
                        </a>
                    </h3>

                    <?php if ($category) {
                        // remove type visually as it already appears ?>
                        <span class="visually-hidden"><?= $category->name; ?></span>
                    <?php } ?>

                    <div class="b-post__desc mb-auto flow <?= has_excerpt() ? 'b-post__desc--excerpt' : 'b-post__desc--content'; ?>">
                        <?= Blue2\Scruffy\Utils::excerpt(null, 25); ?>
                    </div>

                    <div class="b-post__arrow fal fa-long-arrow-right"></div>
                </article>
                </li>
            <?php } ?>
        </ul>
    <?php } ?>
</section>

<?php
wp_reset_postdata();
