<?php
/**
 * Template for post within archive pages
 */

$title = get_the_title();
$link = get_the_permalink();
$category = Blue2\Scruffy\Utils::get_primary_term();

?>

<div class="col-12 col-md-6 col-lg-4">
    <article class="b-post flex-column flow">
        <?php if ($category) {
            // remove type from accessibility tree as it sits before title ?>
            <div aria-hidden="true"><?= $category->name; ?></div>
        <?php } ?>

        <h3>
            <a href="<?= $link; ?>" class="b-post__link text-decoration-none">
                <?= $title; ?>
            </a>
        </h3>

        <?php if ($category) {
            // remove type visually as it already appears ?>
            <span class="visually-hidden"><?= $category->name; ?></span>
        <?php } ?>

        <div class="b-post__desc mb-auto flow <?= has_excerpt() ? 'b-post__desc--excerpt' : 'b-post__desc--content'; ?>">
            <?= Blue2\Scruffy\Utils::excerpt(null, 25); ?>
        </div>

        <div class="b-post__arrow fal fa-long-arrow-right"></div>
    </article>
</div>
