<?php

namespace Blue2\Scruffy\Controllers;

/**
 * ContactForm7
 *
 * Modifies Contact Form 7 functionality, mostly switching to native browser validation
 */
class ContactForm7
{
    public function __construct()
    {
        $this->registerFilters();
    }

    public function registerFilters()
    {
        // didable loading of CSS and JS
        add_filter('wpcf7_load_css', '__return_false');
        add_filter('wpcf7_load_js', '__return_false');

        // remove novalidate attribute from form tag
        add_filter('wpcf7_form_novalidate', '__return_false');

        // our filters
        add_filter('wpcf7_form_elements', [$this, 'filter']);
        add_filter('wpcf7_form_tag', [$this, 'custom_attr']);
        add_filter('wpcf7_form_elements', [$this, 'alert']);
    }

    /**
     * filter
     *
     * filter html to add browser validation and remove
     * aria-attributes from custom validation method
     *
     * @param  string $html
     * @return string
     */
    function filter($html) {
        // replace aria-required with required for default browser validation
        $html = str_replace('aria-required="true"', 'required', $html);

        // remove aria-invalid
        $html = str_replace('aria-invalid="false"', '', $html);

        return $html;
    }

    /**
     * custom_attr
     *
     * add custom attributes to fields using attr-name format
     *
     * @param  array $tag
     * @return array
     */
    function custom_attr($tag) {
        $prefix = 'attr-';

        $attrs = [];

        // loop through options, run for any custom attributes
        foreach ((array) $tag['options'] as $option) {
            if (strpos($option, $prefix) === 0 ) {
                // remove prefix from option name
                $option = substr($option, strlen($prefix));

                // split option between name and value
                $option = explode(':', $option, 2);
                $option_name = $option[0];

                // format value
                $option_value = str_replace('_', ' ', $option[1]);

                // add option to $attrs
                $attrs[$option_name] = apply_filters('wpcf7_option_value', $option_value, $option_name);
            }
        }

        // if there is $attrs
        if (!empty($attrs)) {
            // store name and replace with unique id so we can filter just this field
            $name = $tag['name'];
            $tag['name'] = $id = uniqid('wpcf');

            // add filter to add the attributes and replace the name
            add_filter('wpcf7_form_elements', function ($content) use ($name, $id, $attrs) {
                return str_replace($id, $name, str_replace("name=\"$id\"", "name=\"$name\" " . wpcf7_format_atts($attrs), $content));
            });
        }

        return $tag;
    }

    /**
     * alert
     *
     * filter html output to modify html of alert to be more
     * useful to assisitive technologies
     *
     * @param  string $html
     * @return string
     */
    function alert($html) {
        $html = str_replace(
            'class="wpcf7-response-output" aria-hidden="true"',
            'class="wpcf7-response-output" role="alert"',
            $html
        );

        return $html;
    }
}
