<?php
/**
 * Link Content Section
 *
 * Flexible content section for 'link_content' section.
 *
 * @package DVVA_Theme
 */

$title = get_sub_field('title');
$description = get_sub_field('description');
$image = get_sub_field('image');
$links = get_sub_field('links');
$id = get_sub_field('id');

?>

<section
    <?= $id ? 'id="' . $id . '"' : '' ?>
    class="s-linkContent fs-7">
    <div class="contain">
        <div class="row">
            <div class="col-12 col-lg-4">
                <?php if ($image) { ?>
                    <?= \Blue2\Scruffy\Utils::acf_img($image); ?>
                <?php } ?>
            </div>

            <div class="col-12 col-lg-8 flow">
                <h2><?= $title; ?></h2>
                <p><?= $description; ?></p>

                <?php if ($links) { ?>
                    <ul class="s-linkContent__list" role="list">
                        <?php foreach ($links as $link) { ?>
                            <li class="s-linkContent__item">
                                <h3 class="s-linkContent__title">
                                    <?php
                                    if ($link['link'] && $link['link']['url']) { ?>
                                        <a href="<?= $link['link']['url']; ?>" class="s-linkContent__link text-decoration-none"><?= $link['title']; ?></a>
                                    <?php } else {
                                        echo $link['title'];
                                    } ?>
                                </h3>

                                <?php if ($link['link'] && $link['link']['url']) {
                                    $label = $link['link']['title'] ?: 'Learn more';
                                    ?>
                                    <span class="s-linkContent__button b-button" data-style="fill" aria-hidden="true">
                                        <span class="b-button__text"><?= $label; ?></span>
                                        <span class="b-button__icon fal fa-long-arrow-right"></span>
                                    </span>
                                <?php } ?>
                            </li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
